/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.management.web.server.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourcesHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpResourcesHandler.class);
    private static final String RESOURCES_BASE_PATH = "/native-agent";
    private static final Set<String> ALLOWED_EXTENSIONS;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FullHttpResponse handlerResources(FullHttpRequest request, String path) {
        try {
            if (request == null) return null;
            if (path == null) {
                return null;
            }
            String normalizedPath = this.normalizePath(path);
            if (normalizedPath == null) {
                return null;
            }
            URL resourceUrl = this.getClass().getResource(RESOURCES_BASE_PATH + normalizedPath);
            if (resourceUrl == null) {
                return null;
            }
            try (InputStream is = resourceUrl.openStream();){
                if (is == null) {
                    FullHttpResponse fullHttpResponse = null;
                    return fullHttpResponse;
                }
                ByteBuf content = this.readInputStream(is);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK, content);
                HttpHeaders headers = response.headers();
                headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.getContentType(normalizedPath));
                headers.setInt(HttpHeaderNames.CONTENT_LENGTH, content.readableBytes());
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                DefaultFullHttpResponse defaultFullHttpResponse = response;
                return defaultFullHttpResponse;
            }
        }
        catch (Exception e) {
            logger.error("");
            return null;
        }
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = (path = path.replaceAll("\\.\\./", "").replaceAll("\\./", "")).startsWith("/") ? path : "/" + path;
        String finalPath = path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        boolean hasAllowedExtension = ALLOWED_EXTENSIONS.stream().anyMatch(finalPath::endsWith);
        if (!hasAllowedExtension) {
            return null;
        }
        return path;
    }

    private String getContentType(String path) {
        if (path.endsWith(".html")) {
            return "text/html";
        }
        if (path.endsWith(".css")) {
            return "text/css";
        }
        if (path.endsWith(".js")) {
            return "application/javascript";
        }
        if (path.endsWith(".ico")) {
            return "image/x-icon";
        }
        if (path.endsWith(".png")) {
            return "image/png";
        }
        return "application/octet-stream";
    }

    private ByteBuf readInputStream(InputStream is) throws IOException {
        int length;
        ByteBuf buffer = Unpooled.buffer();
        byte[] tmp = new byte[1024];
        while ((length = is.read(tmp)) != -1) {
            buffer.writeBytes(tmp, 0, length);
        }
        is.close();
        return buffer;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add(".html");
        tempSet.add(".css");
        tempSet.add(".js");
        tempSet.add(".ico");
        tempSet.add(".png");
        ALLOWED_EXTENSIONS = Collections.unmodifiableSet(tempSet);
    }
}

