/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.management.web.discovery.impl;

import com.alibaba.arthas.nat.agent.management.web.discovery.NativeAgentProxyDiscovery;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZookeeperNativeAgentProxyDiscovery
implements NativeAgentProxyDiscovery {
    private static final int SESSION_TIMEOUT = 20000;
    private static final CountDownLatch connectedSemaphore = new CountDownLatch(1);

    @Override
    public List<String> listNativeAgentProxy(String address) {
        if (address == null || "".equals(address)) {
            return null;
        }
        try {
            ZooKeeper zooKeeper = new ZooKeeper(address, 20000, event -> {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    connectedSemaphore.countDown();
                }
            });
            connectedSemaphore.await();
            List<String> children = zooKeeper.getChildren("/native-agent-proxy", false);
            if (children == null || children.size() == 0) {
                return children;
            }
            zooKeeper.close();
            return children;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

