/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.spring;

import com.alibaba.arthas.spring.ArthasProperties;
import com.alibaba.arthas.spring.StringUtils;
import com.taobao.arthas.agent.attach.ArthasAgent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;

@ConditionalOnProperty(name={"spring.arthas.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ArthasProperties.class})
public class ArthasConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ArthasConfiguration.class);
    @Autowired
    ConfigurableEnvironment environment;

    @ConfigurationProperties(prefix="arthas")
    @ConditionalOnMissingBean
    @Bean
    public HashMap<String, String> arthasConfigMap() {
        return new HashMap<String, String>();
    }

    @ConditionalOnMissingBean
    @Bean
    public ArthasAgent arthasAgent(@Autowired Map<String, String> arthasConfigMap, @Autowired ArthasProperties arthasProperties) throws Throwable {
        arthasConfigMap = StringUtils.removeDashKey(arthasConfigMap);
        String appName = this.environment.getProperty("spring.application.name");
        if (arthasConfigMap.get("appName") == null && appName != null) {
            arthasConfigMap.put("appName", appName);
        }
        HashMap<String, String> mapWithPrefix = new HashMap<String, String>(arthasConfigMap.size());
        for (Map.Entry<String, String> entry : arthasConfigMap.entrySet()) {
            mapWithPrefix.put("arthas." + entry.getKey(), entry.getValue());
        }
        ArthasAgent arthasAgent = new ArthasAgent(mapWithPrefix, arthasProperties.getHome(), arthasProperties.isSlientInit(), null);
        arthasAgent.init();
        logger.info("Arthas agent start success.");
        return arthasAgent;
    }
}

