/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.compiler;

import com.taobao.arthas.compiler.DynamicClassLoader;
import com.taobao.arthas.compiler.DynamicCompilerException;
import com.taobao.arthas.compiler.DynamicJavaFileManager;
import com.taobao.arthas.compiler.StringSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class DynamicCompiler {
    private final JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager standardFileManager;
    private final List<String> options = new ArrayList<String>();
    private final DynamicClassLoader dynamicClassLoader;
    private final Collection<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
    private final List<Diagnostic<? extends JavaFileObject>> errors = new ArrayList<Diagnostic<? extends JavaFileObject>>();
    private final List<Diagnostic<? extends JavaFileObject>> warnings = new ArrayList<Diagnostic<? extends JavaFileObject>>();

    public DynamicCompiler(ClassLoader classLoader) {
        if (this.javaCompiler == null) {
            throw new IllegalStateException("Can not load JavaCompiler from javax.tools.ToolProvider#getSystemJavaCompiler(), please confirm the application running in JDK not JRE.");
        }
        this.standardFileManager = this.javaCompiler.getStandardFileManager(null, null, null);
        this.options.add("-Xlint:unchecked");
        this.dynamicClassLoader = new DynamicClassLoader(classLoader);
    }

    public void addSource(String className, String source) {
        this.addSource(new StringSource(className, source));
    }

    public void addSource(JavaFileObject javaFileObject) {
        this.compilationUnits.add(javaFileObject);
    }

    public Map<String, Class<?>> build() {
        this.errors.clear();
        this.warnings.clear();
        DynamicJavaFileManager fileManager = new DynamicJavaFileManager(this.standardFileManager, this.dynamicClassLoader);
        DiagnosticCollector collector = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.javaCompiler.getTask(null, fileManager, collector, this.options, null, this.compilationUnits);
        try {
            boolean result22;
            if (!(this.compilationUnits.isEmpty() || (result22 = task.call().booleanValue()) && collector.getDiagnostics().size() <= 0)) {
                block8: for (Diagnostic diagnostic : collector.getDiagnostics()) {
                    switch (diagnostic.getKind()) {
                        case NOTE: 
                        case MANDATORY_WARNING: 
                        case WARNING: {
                            this.warnings.add(diagnostic);
                            continue block8;
                        }
                    }
                    this.errors.add(diagnostic);
                }
                if (!this.errors.isEmpty()) {
                    throw new DynamicCompilerException("Compilation Error", this.errors);
                }
            }
            Map<String, Class<?>> result22 = this.dynamicClassLoader.getClasses();
            return result22;
        }
        catch (Throwable e) {
            throw new DynamicCompilerException(e, this.errors);
        }
        finally {
            this.compilationUnits.clear();
        }
    }

    public Map<String, byte[]> buildByteCodes() {
        this.errors.clear();
        this.warnings.clear();
        DynamicJavaFileManager fileManager = new DynamicJavaFileManager(this.standardFileManager, this.dynamicClassLoader);
        DiagnosticCollector collector = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.javaCompiler.getTask(null, fileManager, collector, this.options, null, this.compilationUnits);
        try {
            boolean result22;
            if (!(this.compilationUnits.isEmpty() || (result22 = task.call().booleanValue()) && collector.getDiagnostics().size() <= 0)) {
                block8: for (Diagnostic diagnostic : collector.getDiagnostics()) {
                    switch (diagnostic.getKind()) {
                        case NOTE: 
                        case MANDATORY_WARNING: 
                        case WARNING: {
                            this.warnings.add(diagnostic);
                            continue block8;
                        }
                    }
                    this.errors.add(diagnostic);
                }
                if (!this.errors.isEmpty()) {
                    throw new DynamicCompilerException("Compilation Error", this.errors);
                }
            }
            Map<String, byte[]> result22 = this.dynamicClassLoader.getByteCodes();
            return result22;
        }
        catch (ClassFormatError e) {
            throw new DynamicCompilerException(e, this.errors);
        }
        finally {
            this.compilationUnits.clear();
        }
    }

    private List<String> diagnosticToString(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        ArrayList<String> diagnosticMessages = new ArrayList<String>();
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            diagnosticMessages.add("line: " + diagnostic.getLineNumber() + ", message: " + diagnostic.getMessage(Locale.US));
        }
        return diagnosticMessages;
    }

    public List<String> getErrors() {
        return this.diagnosticToString(this.errors);
    }

    public List<String> getWarnings() {
        return this.diagnosticToString(this.warnings);
    }

    public ClassLoader getClassLoader() {
        return this.dynamicClassLoader;
    }
}

