/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.compiler;

import com.taobao.arthas.compiler.CustomJavaFileObject;
import com.taobao.arthas.compiler.DynamicClassLoader;
import com.taobao.arthas.compiler.MemoryByteCode;
import com.taobao.arthas.compiler.PackageInternalsFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class DynamicJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final PackageInternalsFinder finder;
    private final DynamicClassLoader classLoader;
    private final List<MemoryByteCode> byteCodes = new ArrayList<MemoryByteCode>();

    public DynamicJavaFileManager(JavaFileManager fileManager, DynamicClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
        this.finder = new PackageInternalsFinder(classLoader);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        for (MemoryByteCode byteCode : this.byteCodes) {
            if (!byteCode.getClassName().equals(className)) continue;
            return byteCode;
        }
        MemoryByteCode innerClass = new MemoryByteCode(className);
        this.byteCodes.add(innerClass);
        this.classLoader.registerCompiledSource(innerClass);
        return innerClass;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof CustomJavaFileObject) {
            return ((CustomJavaFileObject)file).binaryName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return super.list(location, packageName, kinds, recurse);
        }
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            if (packageName.startsWith("java")) {
                return super.list(location, packageName, kinds, recurse);
            }
            return this.finder.find(packageName);
        }
        return Collections.emptyList();
    }
}

