/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.ValueFilter;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpObjectVOFilter
implements ValueFilter {
    private static final Logger logger = LoggerFactory.getLogger(McpObjectVOFilter.class);

    public Object apply(Object object, String name, Object value) {
        if (value == null) {
            return null;
        }
        String className = value.getClass().getName();
        if (className.endsWith(".ObjectVO")) {
            return this.handleObjectVO(value);
        }
        return value;
    }

    private Object handleObjectVO(Object objectVO) {
        try {
            Object innerObject = this.getFieldValue(objectVO, "object");
            Integer expand = (Integer)this.getFieldValue(objectVO, "expand");
            if (innerObject == null) {
                return "null";
            }
            return this.needExpand(expand) ? this.drawObjectView(innerObject) : this.objectToString(innerObject);
        }
        catch (Exception e) {
            logger.warn("Failed to handle ObjectVO: {}", (Object)e.getMessage());
            return "{\"error\":\"ObjectVO serialization failed\"}";
        }
    }

    private String drawObjectView(Object object) {
        try {
            JSONWriter.Context context = JSONFactory.createWriteContext();
            context.setMaxLevel(4097);
            context.config(JSONWriter.Feature.IgnoreErrorGetter, true);
            context.config(JSONWriter.Feature.ReferenceDetection, true);
            context.config(JSONWriter.Feature.IgnoreNonFieldGetter, true);
            context.config(JSONWriter.Feature.WriteNonStringKeyAsString, true);
            return JSON.toJSONString((Object)object, (JSONWriter.Context)context);
        }
        catch (Exception e) {
            logger.debug("ObjectView-style serialization failed, using toString: {}", (Object)e.getMessage());
            return this.objectToString(object);
        }
    }

    private String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            return object.toString();
        }
        catch (Exception e) {
            return object.getClass().getSimpleName() + "@" + Integer.toHexString(object.hashCode());
        }
    }

    private boolean needExpand(Integer expand) {
        return expand != null && expand > 0;
    }

    private Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            logger.debug("Failed to get field {} from {}: {}", new Object[]{fieldName, obj.getClass().getSimpleName(), e.getMessage()});
            return null;
        }
    }
}

