/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.tool.function.monitor200;

import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;
import com.taobao.arthas.mcp.server.tool.function.AbstractArthasTool;

public class MonitorTool
extends AbstractArthasTool {
    public static final int DEFAULT_NUMBER_OF_EXECUTIONS = 3;
    public static final int DEFAULT_REFRESH_INTERVAL_MS = 3000;
    public static final int DEFAULT_MAX_MATCH_COUNT = 50;

    @Tool(name="monitor", description="Monitor \u65b9\u6cd5\u8c03\u7528\u76d1\u63a7\u5de5\u5177: \u5b9e\u65f6\u76d1\u63a7\u6307\u5b9a\u7c7b\u7684\u6307\u5b9a\u65b9\u6cd5\u7684\u8c03\u7528\u60c5\u51b5\uff0c\u5305\u62ec\u8c03\u7528\u6b21\u6570\u3001\u6210\u529f\u6b21\u6570\u3001\u5931\u8d25\u6b21\u6570\u3001\u5e73\u5747RT\u3001\u5931\u8d25\u7387\u7b49\u7edf\u8ba1\u4fe1\u606f\u3002\u5bf9\u5e94 Arthas \u7684 monitor \u547d\u4ee4\u3002", streamable=true)
    public String monitor(@ToolParam(description="\u7c7b\u540d\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u652f\u6301\u901a\u914d\u7b26\uff0c\u5982demo.MathGame") String classPattern, @ToolParam(description="\u65b9\u6cd5\u540d\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u652f\u6301\u901a\u914d\u7b26\uff0c\u5982primeFactors", required=false) String methodPattern, @ToolParam(description="OGNL\u6761\u4ef6\u8868\u8fbe\u5f0f\uff0c\u6ee1\u8db3\u6761\u4ef6\u7684\u8c03\u7528\u624d\u4f1a\u88ab\u76d1\u63a7\uff0c\u5982params[0]<0", required=false) String condition, @ToolParam(description="\u76d1\u63a7\u7edf\u8ba1\u8f93\u51fa\u95f4\u9694\uff0c\u5355\u4f4d\u4e3a\u6beb\u79d2\uff0c\u9ed8\u8ba4 3000ms\u3002\u7528\u4e8e\u63a7\u5236\u8f93\u51fa\u9891\u7387", required=false) Integer intervalMs, @ToolParam(description="\u6267\u884c\u6b21\u6570\u9650\u5236\uff0c\u9ed8\u8ba4\u503c\u4e3a3\u3002\u8fbe\u5230\u6307\u5b9a\u6b21\u6570\u540e\u81ea\u52a8\u505c\u6b62", required=false) Integer numberOfExecutions, @ToolParam(description="\u5f00\u542f\u6b63\u5219\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u9ed8\u8ba4\u4e3a\u901a\u914d\u7b26\u5339\u914d\uff0c\u9ed8\u8ba4false", required=false) Boolean regex, @ToolParam(description="\u6700\u5927\u5339\u914d\u7c7b\u6570\u91cf\uff0c\u9632\u6b62\u5339\u914d\u8fc7\u591a\u7c7b\u5f71\u54cd\u6027\u80fd\uff0c\u9ed8\u8ba450", required=false) Integer maxMatch, ToolContext toolContext) {
        int interval = this.getDefaultValue(intervalMs, 3000);
        int execCount = this.getDefaultValue(numberOfExecutions, 3);
        int maxMatchCount = this.getDefaultValue(maxMatch, 50);
        StringBuilder cmd = this.buildCommand("monitor");
        cmd.append(" -c ").append(interval / 1000);
        cmd.append(" -n ").append(execCount);
        cmd.append(" -m ").append(maxMatchCount);
        this.addFlag(cmd, "-E", regex);
        this.addParameter(cmd, classPattern);
        if (methodPattern != null && !methodPattern.trim().isEmpty()) {
            cmd.append(" ").append(methodPattern.trim());
        }
        this.addQuotedParameter(cmd, condition);
        return this.executeStreamable(toolContext, cmd.toString(), execCount, interval / 10, "Monitor execution completed successfully");
    }
}

