/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.session;

import com.taobao.arthas.mcp.server.CommandExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArthasCommandSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(ArthasCommandSessionManager.class);
    private final CommandExecutor commandExecutor;
    private final ConcurrentHashMap<String, CommandSessionBinding> sessionBindings = new ConcurrentHashMap();

    public ArthasCommandSessionManager(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public CommandSessionBinding createCommandSession(String mcpSessionId) {
        Map<String, Object> result = this.commandExecutor.createSession();
        CommandSessionBinding binding = new CommandSessionBinding(mcpSessionId, (String)result.get("sessionId"), (String)result.get("consumerId"));
        return binding;
    }

    public CommandSessionBinding getCommandSession(String mcpSessionId, Object authSubject) {
        CommandSessionBinding binding = this.sessionBindings.get(mcpSessionId);
        if (binding == null) {
            binding = this.createCommandSession(mcpSessionId);
            this.sessionBindings.put(mcpSessionId, binding);
            logger.debug("Created new command session: MCP={}, Arthas={}", (Object)mcpSessionId, (Object)binding.getArthasSessionId());
        } else if (!this.isSessionValid(binding)) {
            logger.info("Session expired, recreating: MCP={}, Arthas={}", (Object)mcpSessionId, (Object)binding.getArthasSessionId());
            try {
                this.commandExecutor.closeSession(binding.getArthasSessionId());
            }
            catch (Exception e) {
                logger.debug("Failed to close expired session (may already be cleaned up): {}", (Object)e.getMessage());
            }
            CommandSessionBinding newBinding = this.createCommandSession(mcpSessionId);
            this.sessionBindings.put(mcpSessionId, newBinding);
            logger.info("Recreated command session: MCP={}, Old Arthas={}, New Arthas={}", new Object[]{mcpSessionId, binding.getArthasSessionId(), newBinding.getArthasSessionId()});
            binding = newBinding;
        } else {
            logger.debug("Using existing valid session: MCP={}, Arthas={}", (Object)mcpSessionId, (Object)binding.getArthasSessionId());
        }
        if (authSubject != null) {
            try {
                this.commandExecutor.setSessionAuth(binding.getArthasSessionId(), authSubject);
                logger.debug("Applied auth to Arthas session: MCP={}, Arthas={}", (Object)mcpSessionId, (Object)binding.getArthasSessionId());
            }
            catch (Exception e) {
                logger.warn("Failed to apply auth to session: MCP={}, Arthas={}, error={}", new Object[]{mcpSessionId, binding.getArthasSessionId(), e.getMessage()});
            }
        }
        return binding;
    }

    private boolean isSessionValid(CommandSessionBinding binding) {
        try {
            Map<String, Object> result = this.commandExecutor.pullResults(binding.getArthasSessionId(), binding.getConsumerId());
            if (result == null) {
                return true;
            }
            Boolean success = (Boolean)result.get("success");
            if (Boolean.TRUE.equals(success)) {
                return true;
            }
            String errorMessage = (String)result.get("error");
            if (errorMessage != null && (errorMessage.contains("Session not found") || errorMessage.contains("Consumer not found") || errorMessage.contains("session is inactive"))) {
                logger.debug("Session validation failed: {}", (Object)errorMessage);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.debug("Session validation error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public void closeCommandSession(String mcpSessionId) {
        CommandSessionBinding binding = this.sessionBindings.remove(mcpSessionId);
        if (binding != null) {
            this.commandExecutor.closeSession(binding.getArthasSessionId());
            logger.debug("Closed command session: MCP={}, Arthas={}", (Object)mcpSessionId, (Object)binding.getArthasSessionId());
        }
    }

    public void closeAllSessions() {
        ((ConcurrentHashMap.KeySetView)this.sessionBindings.keySet()).forEach(this::closeCommandSession);
    }

    public static class CommandSessionBinding {
        private final String mcpSessionId;
        private final String arthasSessionId;
        private final String consumerId;

        public CommandSessionBinding(String mcpSessionId, String arthasSessionId, String consumerId) {
            this.mcpSessionId = mcpSessionId;
            this.arthasSessionId = arthasSessionId;
            this.consumerId = consumerId;
        }

        public String getMcpSessionId() {
            return this.mcpSessionId;
        }

        public String getArthasSessionId() {
            return this.arthasSessionId;
        }

        public String getConsumerId() {
            return this.consumerId;
        }
    }
}

