/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy;

import io.grpc.Metadata;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MetadataUtil {
    private static final String BINARY_HEADER_SUFFIX = "-bin";
    private static final String GRPC_HEADER_PREFIX = "x-grpc-";
    private static final List<String> EXCLUDED = Arrays.asList("x-grpc-web", "content-type", "grpc-accept-encoding", "grpc-encoding");

    MetadataUtil() {
    }

    static Metadata getHtpHeaders(HttpHeaders headers) {
        Metadata httpHeaders = new Metadata();
        Set headerNames = headers.names();
        if (headerNames == null) {
            return httpHeaders;
        }
        for (String headerName : headerNames) {
            List values;
            if (EXCLUDED.contains(headerName.toLowerCase()) || !headerName.toLowerCase().startsWith(GRPC_HEADER_PREFIX) || (values = headers.getAll(headerName)) == null) continue;
            for (String s : values) {
                if (headerName.toLowerCase().endsWith(BINARY_HEADER_SUFFIX)) {
                    httpHeaders.put(Metadata.Key.of((String)headerName, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER), (Object)s.getBytes());
                    continue;
                }
                httpHeaders.put(Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)s);
            }
        }
        return httpHeaders;
    }

    static Map<String, String> getHttpHeadersFromMetadata(Metadata trailer) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : trailer.keys()) {
            Object value;
            if (EXCLUDED.contains(key.toLowerCase())) continue;
            if (key.endsWith(BINARY_HEADER_SUFFIX)) {
                value = (byte[])trailer.get(Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER));
                map.put(key, new String((byte[])value));
                continue;
            }
            value = (String)trailer.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            map.put(key, (String)value);
        }
        return map;
    }
}

