/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.grpcweb.proxy.MessageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;

public class MessageDeframer {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    static final byte DATA_BYTE = 0;
    private int mLength = 0;
    private int mReadSoFar = 0;
    private ArrayList<byte[]> mFrames = new ArrayList();
    private byte[] mMsg = null;
    private int mNumFrames;

    byte[] getMessageBytes() {
        return this.mMsg;
    }

    int getLength() {
        return this.mLength;
    }

    int getNumberOfFrames() {
        return this.mNumFrames;
    }

    public boolean processInput(InputStream in, MessageUtils.ContentType contentType) {
        byte[] inBytes;
        try {
            InputStream inStream = contentType == MessageUtils.ContentType.GRPC_WEB_TEXT ? Base64.getDecoder().wrap(in) : in;
            inBytes = IOUtils.getBytes((InputStream)inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.warn("invalid input");
            return false;
        }
        if (inBytes.length < 5) {
            logger.debug("invalid input. Expected minimum of 5 bytes");
            return false;
        }
        while (this.getNextFrameBytes(inBytes)) {
        }
        this.mNumFrames = this.mFrames.size();
        if (this.mNumFrames == 1) {
            this.mMsg = this.mFrames.get(0);
        } else {
            this.mMsg = new byte[this.mLength];
            int offset = 0;
            for (byte[] f : this.mFrames) {
                System.arraycopy(f, 0, this.mMsg, offset, f.length);
                offset += f.length;
            }
            this.mFrames = null;
        }
        return true;
    }

    private boolean getNextFrameBytes(byte[] inBytes) {
        int firstByteValue = inBytes[this.mReadSoFar] | 0;
        if (firstByteValue != 0) {
            logger.debug("done with DATA bytes");
            return false;
        }
        int offset = this.mReadSoFar + 1;
        int len = ByteBuffer.wrap(inBytes, offset, 4).getInt();
        if (len == 0) {
            this.mFrames.add(new byte[0]);
            return false;
        }
        int expectedNumBytes = len + 5 + this.mReadSoFar;
        if (inBytes.length < expectedNumBytes) {
            logger.warn(String.format("input doesn't have enough bytes. expected: %d, found %d", expectedNumBytes, inBytes.length));
            return false;
        }
        this.mLength += len;
        byte[] inputBytes = Arrays.copyOfRange(inBytes, offset += 4, len + offset);
        this.mFrames.add(inputBytes);
        this.mReadSoFar += len + 5;
        return inBytes.length > this.mReadSoFar;
    }
}

