/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.server;

import arthas.VmTool;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.SocketUtils;
import com.taobao.arthas.core.advisor.TransformerManager;
import com.taobao.arthas.grpcweb.grpc.service.GrpcJobController;
import com.taobao.arthas.grpcweb.grpc.service.ObjectService;
import com.taobao.arthas.grpcweb.grpc.service.PwdCommandService;
import com.taobao.arthas.grpcweb.grpc.service.SystemPropertyCommandService;
import com.taobao.arthas.grpcweb.grpc.service.WatchCommandService;
import com.taobao.arthas.grpcweb.grpc.view.GrpcResultViewResolver;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;

public class GrpcServer {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private int port;
    private Server grpcServer;
    private Instrumentation instrumentation;
    private TransformerManager transformerManager;

    public GrpcServer(int port, Instrumentation instrumentation, TransformerManager transformerManager) {
        this.port = port == 0 ? SocketUtils.findAvailableTcpPort() : port;
        this.instrumentation = instrumentation;
        this.transformerManager = transformerManager;
    }

    public void start() {
        GrpcResultViewResolver grpcResultViewResolver = new GrpcResultViewResolver();
        GrpcJobController grpcJobController = new GrpcJobController(this.instrumentation, this.transformerManager, grpcResultViewResolver);
        File path = new File(VmTool.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();
        String libPath = path.getAbsolutePath();
        try {
            this.grpcServer = ServerBuilder.forPort((int)this.port).addService((BindableService)new ObjectService(grpcJobController, libPath)).addService((BindableService)new PwdCommandService(grpcJobController)).addService((BindableService)new SystemPropertyCommandService(grpcJobController)).addService((BindableService)new WatchCommandService(grpcJobController)).build().start();
            logger.info("Server started, listening on " + this.port);
            Runtime.getRuntime().addShutdownHook(new Thread("grpc-server-shutdown"){

                @Override
                public void run() {
                    if (GrpcServer.this.grpcServer != null) {
                        GrpcServer.this.grpcServer.shutdown();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

