/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.view;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.grpcweb.grpc.observer.ArthasStreamObserver;
import com.taobao.arthas.grpcweb.grpc.view.GrpcEnhancerView;
import com.taobao.arthas.grpcweb.grpc.view.GrpcMessageView;
import com.taobao.arthas.grpcweb.grpc.view.GrpcPwdView;
import com.taobao.arthas.grpcweb.grpc.view.GrpcResultView;
import com.taobao.arthas.grpcweb.grpc.view.GrpcStatusView;
import com.taobao.arthas.grpcweb.grpc.view.GrpcSystemPropertyView;
import com.taobao.arthas.grpcweb.grpc.view.GrpcWatchView;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GrpcResultViewResolver {
    private static final Logger logger = LoggerFactory.getLogger(GrpcResultViewResolver.class);
    private Map<Class, GrpcResultView> resultViewMap = new ConcurrentHashMap<Class, GrpcResultView>();

    public GrpcResultViewResolver() {
        this.initResultViews();
    }

    private void initResultViews() {
        try {
            this.registerView(GrpcStatusView.class);
            this.registerView(GrpcMessageView.class);
            this.registerView(GrpcSystemPropertyView.class);
            this.registerView(GrpcPwdView.class);
            this.registerView(GrpcEnhancerView.class);
            this.registerView(GrpcWatchView.class);
        }
        catch (Throwable e) {
            logger.error("register result view failed", e);
        }
    }

    public GrpcResultView getResultView(ResultModel model) {
        return this.resultViewMap.get(model.getClass());
    }

    public GrpcResultViewResolver registerView(Class modelClass, GrpcResultView view) {
        this.resultViewMap.put(modelClass, view);
        return this;
    }

    public GrpcResultViewResolver registerView(GrpcResultView view) {
        Class modelClass = GrpcResultViewResolver.getModelClass(view);
        if (modelClass == null) {
            throw new NullPointerException("model class is null");
        }
        return this.registerView(modelClass, view);
    }

    public void registerView(Class<? extends GrpcResultView> viewClass) {
        GrpcResultView view = null;
        try {
            view = viewClass.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("create view instance failure, viewClass:" + viewClass, e);
        }
        this.registerView(view);
    }

    public static <V extends GrpcResultView> Class getModelClass(V view) {
        Class<?> viewClass = view.getClass();
        Method[] declaredMethods = viewClass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Class<?>[] parameterTypes;
            Method method = declaredMethods[i];
            if (!method.getName().equals("draw") || (parameterTypes = method.getParameterTypes()).length != 2 || parameterTypes[0] != ArthasStreamObserver.class || parameterTypes[1] == ResultModel.class || !ResultModel.class.isAssignableFrom(parameterTypes[1])) continue;
            return parameterTypes[1];
        }
        return null;
    }
}

