/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.service;

import arthas.VmTool;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.VmToolUtils;
import com.taobao.arthas.core.command.express.Express;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.grpcweb.grpc.objectUtils.JavaObjectConverter;
import com.taobao.arthas.grpcweb.grpc.observer.impl.ArthasStreamObserverImpl;
import com.taobao.arthas.grpcweb.grpc.service.GrpcJobController;
import io.arthas.api.ArthasServices;
import io.arthas.api.ObjectServiceGrpc;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.ArrayList;

public class ObjectService
extends ObjectServiceGrpc.ObjectServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private VmTool vmTool;
    private Instrumentation inst;
    private GrpcJobController grpcJobController;

    public ObjectService(GrpcJobController grpcJobController, String libDir) {
        this.inst = grpcJobController.getInstrumentation();
        this.grpcJobController = grpcJobController;
        try {
            String detectLibName = VmToolUtils.detectLibName();
            String vmToolLibPath = Paths.get(libDir, detectLibName).toString();
            this.vmTool = VmTool.getInstance((String)vmToolLibPath);
        }
        catch (Throwable e) {
            logger.error("init vmtool error", e);
        }
    }

    @Override
    public void query(ArthasServices.ObjectQuery query, StreamObserver<ArthasServices.ObjectQueryResult> responseObserver) {
        if (this.vmTool == null) {
            throw Status.UNAVAILABLE.withDescription("vmtool can not work").asRuntimeException();
        }
        ArthasStreamObserverImpl<ArthasServices.ObjectQueryResult> arthasStreamObserver = new ArthasStreamObserverImpl<ArthasServices.ObjectQueryResult>(responseObserver, null, this.grpcJobController);
        String className = query.getClassName();
        String classLoaderHash = query.getClassLoaderHash();
        String classLoaderClass = query.getClassLoaderClass();
        int limit = query.getLimit();
        int depth = query.getDepth();
        String express = query.getExpress();
        String resultExpress = query.getResultExpress();
        if (ObjectService.isEmpty(classLoaderHash) && ObjectService.isEmpty(classLoaderClass)) {
            ArrayList<Class> foundClassList = new ArrayList<Class>();
            for (Class clazz : this.inst.getAllLoadedClasses()) {
                if (!clazz.getName().equals(className)) continue;
                foundClassList.add(clazz);
            }
            if (foundClassList.size() == 0) {
                arthasStreamObserver.onNext(ArthasServices.ObjectQueryResult.newBuilder().setSuccess(false).setMessage("can not find class: " + className).build());
                arthasStreamObserver.onCompleted();
                return;
            }
            if (foundClassList.size() > 1) {
                String message = "found more than one class: " + className;
                arthasStreamObserver.onNext(ArthasServices.ObjectQueryResult.newBuilder().setSuccess(false).setMessage(message).build());
                arthasStreamObserver.onCompleted();
                return;
            }
            Object[] instances = this.vmTool.getInstances((Class)foundClassList.get(0), limit);
            ArthasServices.ObjectQueryResult.Builder builder = ArthasServices.ObjectQueryResult.newBuilder().setSuccess(true);
            Object value = null;
            if (!ObjectService.isEmpty(express)) {
                Express unpooledExpress = ExpressFactory.unpooledExpress((ClassLoader)((Class)foundClassList.get(0)).getClassLoader());
                try {
                    value = unpooledExpress.bind((Object)new InstancesWrapper(instances)).get(express);
                }
                catch (ExpressException e) {
                    logger.warn("ognl: failed execute express: " + express, (Throwable)e);
                }
            }
            if (value != null && !ObjectService.isEmpty(resultExpress)) {
                try {
                    value = ExpressFactory.threadLocalExpress(value).bind("cost", (Object)0.0).get(resultExpress);
                }
                catch (ExpressException e) {
                    logger.warn("ognl: failed execute result express: " + express, (Throwable)e);
                }
            }
            ArthasServices.JavaObject javaObject = JavaObjectConverter.toJavaObjectWithExpand(value, depth);
            builder.addObjects(javaObject);
            arthasStreamObserver.onNext(builder.build());
            arthasStreamObserver.onCompleted();
            return;
        }
        Class foundClass = null;
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            String hex;
            ClassLoader classLoader;
            if (!clazz.getName().equals(className) || (classLoader = clazz.getClassLoader()) == null) continue;
            if (!ObjectService.isEmpty(classLoaderHash) && classLoaderHash.equals(hex = Integer.toHexString(classLoader.hashCode()))) {
                foundClass = clazz;
                break;
            }
            if (ObjectService.isEmpty(classLoaderClass) || !classLoaderClass.equals(classLoader.getClass().getName())) continue;
            foundClass = clazz;
            break;
        }
        if (foundClass == null) {
            arthasStreamObserver.onNext(ArthasServices.ObjectQueryResult.newBuilder().setSuccess(false).setMessage("can not find class: " + className).build());
            arthasStreamObserver.onCompleted();
            return;
        }
        Object[] instances = this.vmTool.getInstances(foundClass, limit);
        ArthasServices.ObjectQueryResult.Builder builder = ArthasServices.ObjectQueryResult.newBuilder().setSuccess(true);
        Object value = null;
        if (!ObjectService.isEmpty(express)) {
            Express unpooledExpress = ExpressFactory.unpooledExpress((ClassLoader)foundClass.getClassLoader());
            try {
                value = unpooledExpress.bind((Object)new InstancesWrapper(instances)).get(express);
            }
            catch (ExpressException e) {
                logger.warn("ognl: failed execute express: " + express, (Throwable)e);
            }
        }
        if (value != null && !ObjectService.isEmpty(resultExpress)) {
            try {
                value = ExpressFactory.threadLocalExpress(value).bind("cost", (Object)0.0).get(resultExpress);
            }
            catch (ExpressException e) {
                logger.warn("ognl: failed execute result express: " + express, (Throwable)e);
            }
        }
        ArthasServices.JavaObject javaObject = JavaObjectConverter.toJavaObjectWithExpand(value, depth);
        builder.addObjects(javaObject);
        arthasStreamObserver.onNext(builder.build());
        arthasStreamObserver.onCompleted();
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    static class InstancesWrapper {
        Object instances;

        public InstancesWrapper(Object instances) {
            this.instances = instances;
        }

        public Object getInstances() {
            return this.instances;
        }

        public void setInstances(Object instances) {
            this.instances = instances;
        }
    }
}

