/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.model;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.InvokeTraceable;
import com.taobao.arthas.core.command.model.EnhancerModel;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.monitor200.AbstractTraceAdviceListener;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.view.Ansi;
import com.taobao.arthas.grpcweb.grpc.observer.ArthasStreamObserver;
import com.taobao.arthas.grpcweb.grpc.service.advisor.Enhancer;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.List;

public abstract class EnhancerRequestModel {
    private static final Logger logger = LoggerFactory.getLogger(EnhancerRequestModel.class);
    protected static final List<String> EMPTY = Collections.emptyList();
    public static final String[] EXPRESS_EXAMPLES = new String[]{"params", "returnObj", "throwExp", "target", "clazz", "method", "{params,returnObj}", "params[0]"};
    protected String excludeClassPattern;
    protected Matcher classNameMatcher;
    protected Matcher classNameExcludeMatcher;
    protected Matcher methodNameMatcher;
    protected long jobId;
    protected long listenerId;
    protected boolean verbose;
    protected int maxNumOfMatchedClass;

    protected abstract Matcher getClassNameMatcher();

    protected abstract Matcher getClassNameExcludeMatcher();

    protected abstract Matcher getMethodNameMatcher();

    protected abstract AdviceListener getAdviceListener(ArthasStreamObserver var1);

    public void enhance(ArthasStreamObserver arthasStreamObserver) {
        EnhancerAffect effect = null;
        try {
            Instrumentation inst = arthasStreamObserver.getInstrumentation();
            AdviceListener listener = this.getAdviceListener(arthasStreamObserver);
            if (listener == null) {
                logger.error("advice listener is null");
                String msg = "advice listener is null, check arthas log";
                arthasStreamObserver.end(-1, msg);
                return;
            }
            boolean skipJDKTrace = false;
            if (listener instanceof AbstractTraceAdviceListener) {
                skipJDKTrace = ((AbstractTraceAdviceListener)listener).getCommand().isSkipJDKTrace();
            }
            Enhancer enhancer = new Enhancer(listener, listener instanceof InvokeTraceable, skipJDKTrace, this.getClassNameMatcher(), this.getClassNameExcludeMatcher(), this.getMethodNameMatcher());
            arthasStreamObserver.register(listener, enhancer);
            effect = enhancer.enhance(inst, this.maxNumOfMatchedClass);
            if (effect.getThrowable() != null) {
                String msg = "error happens when enhancing class: " + effect.getThrowable().getMessage();
                arthasStreamObserver.end(-1, msg + ", check arthas log: " + LogUtil.loggingFile());
                return;
            }
            if (effect.cCnt() == 0 || effect.mCnt() == 0) {
                if (!StringUtils.isEmpty((Object)effect.getOverLimitMsg())) {
                    String msg = "no class effected";
                    arthasStreamObserver.end(-1, msg);
                    return;
                }
                String smCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("sm CLASS_NAME METHOD_NAME").reset().toString();
                String optionsCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("options unsafe true").reset().toString();
                String javaPackage = Ansi.ansi().fg(Ansi.Color.GREEN).a("java.*").reset().toString();
                String resetCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("reset CLASS_NAME").reset().toString();
                String logStr = Ansi.ansi().fg(Ansi.Color.GREEN).a(LogUtil.loggingFile()).reset().toString();
                String issueStr = Ansi.ansi().fg(Ansi.Color.GREEN).a("https://github.com/alibaba/arthas/issues/47").reset().toString();
                String msg = "No class or method is affected, try:\n1. Execute `" + smCommand + "` to make sure the method you are tracing actually exists (it might be in your parent class).\n2. Execute `" + optionsCommand + "`, if you want to enhance the classes under the `" + javaPackage + "` package.\n3. Execute `" + resetCommand + "` and try again, your method body might be too large.\n4. Match the constructor, use `<init>`, for example: `watch demo.MathGame <init>`\n5. Check arthas log: " + logStr + "\n6. Visit " + issueStr + " for more details.";
                arthasStreamObserver.end(-1, msg);
                return;
            }
            arthasStreamObserver.appendResult((ResultModel)new EnhancerModel(effect, true));
        }
        catch (Throwable e) {
            String msg = "error happens when enhancing class: " + e.getMessage();
            logger.error(msg, e);
            arthasStreamObserver.end(-1, msg);
        }
    }
}

