/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.grpcweb.proxy.CorsUtils;
import com.taobao.arthas.grpcweb.proxy.MessageFramer;
import com.taobao.arthas.grpcweb.proxy.MessageUtils;
import com.taobao.arthas.grpcweb.proxy.MetadataUtil;
import com.taobao.arthas.grpcweb.proxy.SingleHttpChunkedInput;
import io.grpc.Metadata;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Base64;
import java.util.Map;

class SendGrpcWebResponse {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private final String contentType;
    private boolean isHeaderSent = false;
    private boolean isEndChunkSent = false;
    private boolean isTrailerSent = false;
    private Boolean isSuccessSendData = true;
    private ChannelHandlerContext ctx;

    SendGrpcWebResponse(ChannelHandlerContext ctx, FullHttpRequest req) {
        HttpHeaders headers = req.headers();
        this.contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        this.ctx = ctx;
    }

    synchronized void writeHeaders(Metadata headers) {
        if (this.isHeaderSent) {
            return;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType).set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
        CorsUtils.updateCorsHeader(response.headers());
        if (headers != null) {
            Map<String, String> ht = MetadataUtil.getHttpHeadersFromMetadata(headers);
            for (String key : ht.keySet()) {
                response.headers().set(key, (Object)ht.get(key));
            }
        }
        logger.debug("write headers: {}", (Object)response);
        this.ctx.writeAndFlush((Object)response);
        this.isHeaderSent = true;
    }

    synchronized void returnUnimplementedStatusCode(String className) {
        this.writeHeaders(null);
        this.writeTrailer(Status.UNIMPLEMENTED.withDescription("Can not find service impl, check dep, service: " + className), null);
    }

    private void writeEndChunk() {
        if (this.isEndChunkSent) {
            return;
        }
        DefaultLastHttpContent end = new DefaultLastHttpContent();
        this.ctx.writeAndFlush((Object)end);
        this.isEndChunkSent = true;
    }

    synchronized void writeError(Status s) {
        this.writeHeaders(null);
        this.writeTrailer(s, null);
    }

    synchronized void writeTrailer(Status status, Metadata trailer) {
        if (this.isTrailerSent) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (trailer != null) {
            Map<String, String> ht = MetadataUtil.getHttpHeadersFromMetadata(trailer);
            for (String key : ht.keySet()) {
                sb.append(String.format("%s:%s\r\n", key, ht.get(key)));
            }
        }
        sb.append(String.format("grpc-status:%d\r\n", status.getCode().value()));
        if (status.getDescription() != null && !status.getDescription().isEmpty()) {
            sb.append(String.format("grpc-message:%s\r\n", status.getDescription()));
        }
        this.writeResponse(sb.toString().getBytes(), MessageFramer.Type.TRAILER);
        this.isTrailerSent = true;
        this.writeEndChunk();
    }

    synchronized boolean writeResponse(byte[] out) {
        return this.writeResponse(out, MessageFramer.Type.DATA);
    }

    private boolean writeResponse(byte[] out, MessageFramer.Type type) {
        if (this.isTrailerSent) {
            logger.error("grpcweb trailer sented, writeResponse can not be called, framer type: {}", (Object)type);
            return false;
        }
        try {
            byte[] prefix = new MessageFramer().getPrefix(out, type);
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            if (MessageUtils.getContentType(this.contentType) == MessageUtils.ContentType.GRPC_WEB_TEXT) {
                byte[] concated = new byte[out.length + 5];
                System.arraycopy(prefix, 0, concated, 0, 5);
                System.arraycopy(out, 0, concated, 5, out.length);
                oStream.write(Base64.getEncoder().encode(concated));
            } else {
                oStream.write(prefix);
                oStream.write(out);
            }
            byte[] byteArray = oStream.toByteArray();
            ByteArrayInputStream dataStream = new ByteArrayInputStream(byteArray);
            ChunkedStream chunkedStream = new ChunkedStream((InputStream)dataStream);
            SingleHttpChunkedInput httpChunkedInput = new SingleHttpChunkedInput((ChunkedInput<ByteBuf>)chunkedStream);
            ChannelFuture channelFuture = this.ctx.writeAndFlush((Object)httpChunkedInput);
            ChannelFutureListener channelFutureListener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (!future.isSuccess()) {
                        SendGrpcWebResponse.this.isSuccessSendData = false;
                    }
                }
            };
            channelFuture.addListener((GenericFutureListener)channelFutureListener);
            return this.isSuccessSendData;
        }
        catch (IOException e) {
            logger.error("write grpcweb response error, framer type: {}", (Object)type, (Object)e);
            return false;
        }
    }
}

