/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy.server;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.grpcweb.proxy.GrpcServiceConnectionManager;
import com.taobao.arthas.grpcweb.proxy.GrpcWebRequestHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.lang.invoke.MethodHandles;

public class GrpcWebProxyHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private GrpcWebRequestHandler requestHandler;
    private static GrpcServiceConnectionManager manager;

    public GrpcWebProxyHandler(int grpcPort) {
        manager = new GrpcServiceConnectionManager(grpcPort);
        this.requestHandler = new GrpcWebRequestHandler(manager);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        logger.debug("http request: {} ", (Object)request);
        GrpcWebProxyHandler.send100Continue(ctx);
        this.requestHandler.handle(ctx, request);
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        ctx.write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("grpc web proxy handler error", cause);
        ctx.close();
    }
}

