/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MessageUtils {
    private static Map<String, ContentType> GRPC_GCP_CONTENT_TYPES = new HashMap<String, ContentType>(){
        {
            this.put("application/grpc-web", ContentType.GRPC_WEB_BINARY);
            this.put("application/grpc-web+proto", ContentType.GRPC_WEB_BINARY);
            this.put("application/grpc-web-text", ContentType.GRPC_WEB_TEXT);
            this.put("application/grpc-web-text+proto", ContentType.GRPC_WEB_TEXT);
        }
    };

    public static ContentType validateContentType(String contentType) throws IllegalArgumentException {
        if (contentType == null || !GRPC_GCP_CONTENT_TYPES.containsKey(contentType)) {
            throw new IllegalArgumentException("This content type is not used for grpc-web: " + contentType);
        }
        return MessageUtils.getContentType(contentType);
    }

    static ContentType getContentType(String type) {
        return GRPC_GCP_CONTENT_TYPES.get(type);
    }

    static Object getInputProtobufObj(Method rpcMethod, byte[] in) {
        Object inputObj;
        Method parseFromObj;
        Class<?>[] inputArgs = rpcMethod.getParameterTypes();
        Class<?> inputArgClass = inputArgs[0];
        try {
            parseFromObj = inputArgClass.getMethod("parseFrom", byte[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Couldn't find method in 'parseFrom' in " + inputArgClass.getName());
        }
        try {
            inputObj = parseFromObj.invoke(null, new Object[]{in});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        if (inputObj == null || !inputArgClass.isInstance(inputObj)) {
            throw new IllegalArgumentException("Input obj is **not** instance of the correct input class type");
        }
        return inputObj;
    }

    @VisibleForTesting
    public static enum ContentType {
        GRPC_WEB_BINARY,
        GRPC_WEB_TEXT;

    }
}

