/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy.server;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.grpcweb.proxy.server.GrpcWebProxyServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;

public final class GrpcWebProxyServer {
    private static final Logger logger = LoggerFactory.getLogger(GrpcWebProxyServer.class);
    private int port;
    private int grpcPort;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public GrpcWebProxyServer(int port, int grpcPort) {
        this.port = port;
        this.grpcPort = grpcPort;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
    }

    public void start() {
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new GrpcWebProxyServerInitializer(this.grpcPort));
            this.channel = serverBootstrap.bind(this.port).sync().channel();
            logger.info("grpc web proxy server started, listening on " + this.port);
            System.out.println("grpc web proxy server started, listening on " + this.port);
            this.channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.info("fail to start grpc web proxy server!");
            throw new RuntimeException(e);
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }
    }

    public void close() {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        logger.info("success to close grpc web proxy server!");
    }

    public int actualPort() {
        int boundPort = ((InetSocketAddress)this.channel.localAddress()).getPort();
        return boundPort;
    }
}

