/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpc.server.handler;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.grpc.server.handler.GrpcRequest;
import com.taobao.arthas.grpc.server.handler.GrpcResponse;
import com.taobao.arthas.grpc.server.handler.StreamObserver;
import com.taobao.arthas.grpc.server.handler.annotation.GrpcMethod;
import com.taobao.arthas.grpc.server.handler.annotation.GrpcService;
import com.taobao.arthas.grpc.server.handler.constant.GrpcInvokeTypeEnum;
import com.taobao.arthas.grpc.server.utils.ReflectUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GrpcDispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    public static final String DEFAULT_GRPC_SERVICE_PACKAGE_NAME = "com.taobao.arthas.grpc.server.service.impl";
    public static Map<String, MethodHandle> grpcInvokeMap = new HashMap<String, MethodHandle>();
    public static Map<String, MethodHandle> requestParseFromMap = new HashMap<String, MethodHandle>();
    public static Map<String, MethodHandle> requestToByteArrayMap = new HashMap<String, MethodHandle>();
    public static Map<String, MethodHandle> responseParseFromMap = new HashMap<String, MethodHandle>();
    public static Map<String, MethodHandle> responseToByteArrayMap = new HashMap<String, MethodHandle>();
    public static Map<String, GrpcInvokeTypeEnum> grpcInvokeTypeMap = new HashMap<String, GrpcInvokeTypeEnum>();

    public void loadGrpcService(String grpcServicePackageName) {
        List<Class<?>> classes = ReflectUtil.findClasses(Optional.ofNullable(grpcServicePackageName).orElse(DEFAULT_GRPC_SERVICE_PACKAGE_NAME));
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(GrpcService.class)) continue;
            try {
                Method[] declaredMethods;
                GrpcService grpcService = clazz.getAnnotation(GrpcService.class);
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(GrpcMethod.class)) continue;
                    GrpcMethod grpcMethod = method.getAnnotation(GrpcMethod.class);
                    MethodHandle grpcInvoke = lookup.unreflect(method);
                    String grpcMethodKey = GrpcDispatcher.generateGrpcMethodKey(grpcService.value(), grpcMethod.value());
                    grpcInvokeTypeMap.put(grpcMethodKey, grpcMethod.grpcType());
                    grpcInvokeMap.put(grpcMethodKey, grpcInvoke.bindTo(instance));
                    Class<?> requestClass = null;
                    Class<?> responseClass = null;
                    if (GrpcInvokeTypeEnum.UNARY.equals((Object)grpcMethod.grpcType())) {
                        requestClass = grpcInvoke.type().parameterType(1);
                        responseClass = grpcInvoke.type().returnType();
                    } else if (GrpcInvokeTypeEnum.CLIENT_STREAM.equals((Object)grpcMethod.grpcType()) || GrpcInvokeTypeEnum.BI_STREAM.equals((Object)grpcMethod.grpcType())) {
                        responseClass = GrpcDispatcher.getInnerGenericClass(method.getGenericParameterTypes()[0]);
                        requestClass = GrpcDispatcher.getInnerGenericClass(method.getGenericReturnType());
                    } else if (GrpcInvokeTypeEnum.SERVER_STREAM.equals((Object)grpcMethod.grpcType())) {
                        requestClass = GrpcDispatcher.getInnerGenericClass(method.getGenericParameterTypes()[0]);
                        responseClass = GrpcDispatcher.getInnerGenericClass(method.getGenericParameterTypes()[1]);
                    }
                    MethodHandle requestParseFrom = lookup.findStatic(requestClass, "parseFrom", MethodType.methodType(requestClass, byte[].class));
                    MethodHandle responseParseFrom = lookup.findStatic(responseClass, "parseFrom", MethodType.methodType(responseClass, byte[].class));
                    MethodHandle requestToByteArray = lookup.findVirtual(requestClass, "toByteArray", MethodType.methodType(byte[].class));
                    MethodHandle responseToByteArray = lookup.findVirtual(responseClass, "toByteArray", MethodType.methodType(byte[].class));
                    requestParseFromMap.put(grpcMethodKey, requestParseFrom);
                    responseParseFromMap.put(grpcMethodKey, responseParseFrom);
                    requestToByteArrayMap.put(grpcMethodKey, requestToByteArray);
                    responseToByteArrayMap.put(grpcMethodKey, responseToByteArray);
                }
            }
            catch (Throwable e) {
                logger.error("GrpcDispatcher loadGrpcService error.", e);
            }
        }
    }

    public GrpcResponse doUnaryExecute(String service, String method, byte[] arg) throws Throwable {
        MethodHandle methodHandle = grpcInvokeMap.get(GrpcDispatcher.generateGrpcMethodKey(service, method));
        MethodType type = grpcInvokeMap.get(GrpcDispatcher.generateGrpcMethodKey(service, method)).type();
        Object req = requestParseFromMap.get(GrpcDispatcher.generateGrpcMethodKey(service, method)).invoke(arg);
        Object execute = methodHandle.invoke(req);
        GrpcResponse grpcResponse = new GrpcResponse();
        grpcResponse.setClazz((Class<?>)type.returnType());
        grpcResponse.setService(service);
        grpcResponse.setMethod(method);
        grpcResponse.writeResponseData(execute);
        return grpcResponse;
    }

    public GrpcResponse unaryExecute(GrpcRequest request) throws Throwable {
        MethodHandle methodHandle = grpcInvokeMap.get(request.getGrpcMethodKey());
        MethodType type = grpcInvokeMap.get(request.getGrpcMethodKey()).type();
        Object req = requestParseFromMap.get(request.getGrpcMethodKey()).invoke(request.readData());
        Object execute = methodHandle.invoke(req);
        GrpcResponse grpcResponse = new GrpcResponse();
        grpcResponse.setClazz((Class<?>)type.returnType());
        grpcResponse.setService(request.getService());
        grpcResponse.setMethod(request.getMethod());
        grpcResponse.writeResponseData(execute);
        return grpcResponse;
    }

    public StreamObserver<GrpcRequest> clientStreamExecute(GrpcRequest request, StreamObserver<GrpcResponse> responseObserver) throws Throwable {
        MethodHandle methodHandle = grpcInvokeMap.get(request.getGrpcMethodKey());
        return methodHandle.invoke(responseObserver);
    }

    public void serverStreamExecute(GrpcRequest request, StreamObserver<GrpcResponse> responseObserver) throws Throwable {
        MethodHandle methodHandle = grpcInvokeMap.get(request.getGrpcMethodKey());
        Object req = requestParseFromMap.get(request.getGrpcMethodKey()).invoke(request.readData());
        methodHandle.invoke(req, responseObserver);
    }

    public StreamObserver<GrpcRequest> biStreamExecute(GrpcRequest request, StreamObserver<GrpcResponse> responseObserver) throws Throwable {
        MethodHandle methodHandle = grpcInvokeMap.get(request.getGrpcMethodKey());
        return methodHandle.invoke(responseObserver);
    }

    public static Class<?> getRequestClass(String serviceName, String methodName) {
        return Optional.ofNullable(grpcInvokeMap.get(GrpcDispatcher.generateGrpcMethodKey(serviceName, methodName))).orElseThrow(() -> new RuntimeException("The specified grpc method does not exist")).type().parameterArray()[0];
    }

    public static String generateGrpcMethodKey(String serviceName, String methodName) {
        return serviceName + "." + methodName;
    }

    public static void checkGrpcType(GrpcRequest request) {
        request.setGrpcType(Optional.ofNullable(grpcInvokeTypeMap.get(GrpcDispatcher.generateGrpcMethodKey(request.getService(), request.getMethod()))).orElse(GrpcInvokeTypeEnum.UNARY));
        request.setStreamFirstData(true);
    }

    public static Class<?> getInnerGenericClass(Type type) {
        ParameterizedType paramType;
        Type[] actualTypeArguments;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (actualTypeArguments = (paramType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            Type innerType = actualTypeArguments[0];
            if (innerType instanceof ParameterizedType) {
                return GrpcDispatcher.getInnerGenericClass(innerType);
            }
            if (innerType instanceof Class) {
                return (Class)innerType;
            }
        }
        return null;
    }
}

