/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpc.server.handler;

import arthas.grpc.common.ArthasGrpc;
import com.taobao.arthas.grpc.server.handler.GrpcDispatcher;
import com.taobao.arthas.grpc.server.handler.annotation.GrpcMethod;
import com.taobao.arthas.grpc.server.handler.annotation.GrpcService;
import com.taobao.arthas.grpc.server.utils.ByteUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class GrpcResponse<T> {
    private Map<String, String> headers = new HashMap<String, String>();
    private String service;
    private String method;
    private ByteBuf byteData;
    private Class<?> clazz;

    public GrpcResponse() {
        this.headers.put("content-type", "application/grpc");
        this.headers.put("grpc-encoding", "identity");
        this.headers.put("grpc-accept-encoding", "identity,deflate,gzip");
    }

    public GrpcResponse(Method method) {
        this.headers.put("content-type", "application/grpc");
        this.headers.put("grpc-encoding", "identity");
        this.headers.put("grpc-accept-encoding", "identity,deflate,gzip");
        this.service = method.getDeclaringClass().getAnnotation(GrpcService.class).value();
        this.method = method.getAnnotation(GrpcMethod.class).value();
    }

    public Http2Headers getEndHeader() {
        Http2Headers endHeader = new DefaultHttp2Headers().status((CharSequence)"200");
        this.headers.forEach((arg_0, arg_1) -> ((Http2Headers)endHeader).set(arg_0, arg_1));
        return endHeader;
    }

    public Http2Headers getEndStreamHeader() {
        return (Http2Headers)new DefaultHttp2Headers().set((Object)"grpc-status", (Object)"0");
    }

    public static Http2Headers getDefaultEndStreamHeader() {
        return (Http2Headers)new DefaultHttp2Headers().set((Object)"grpc-status", (Object)"0");
    }

    public ByteBuf getResponseData() {
        return this.byteData;
    }

    public void writeResponseData(Object response) {
        byte[] encode = null;
        try {
            encode = ArthasGrpc.ErrorRes.class.equals(this.clazz) ? ((ArthasGrpc.ErrorRes)response).toByteArray() : GrpcDispatcher.responseToByteArrayMap.get(GrpcDispatcher.generateGrpcMethodKey(this.service, this.method)).invoke(response);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.byteData = ByteUtil.newByteBuf();
        this.byteData.writeBoolean(false);
        this.byteData.writeInt(encode.length);
        this.byteData.writeBytes(encode);
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

