/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExecutingCommand {
    private ExecutingCommand() {
    }

    public static List<String> runNative(String cmdToRun) {
        String[] cmd = cmdToRun.split(" ");
        return ExecutingCommand.runNative(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> runNative(String[] cmdToRunWithArgs) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdToRunWithArgs);
        }
        catch (SecurityException e) {
            AnsiLog.trace("Couldn't run command {}:", Arrays.toString(cmdToRunWithArgs));
            AnsiLog.trace(e);
            return new ArrayList<String>(0);
        }
        catch (IOException e) {
            AnsiLog.trace("Couldn't run command {}:", Arrays.toString(cmdToRunWithArgs));
            AnsiLog.trace(e);
            return new ArrayList<String>(0);
        }
        ArrayList<String> sa = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sa.add(line);
            }
            p.waitFor();
        }
        catch (IOException e) {
            AnsiLog.trace("Problem reading output from {}:", Arrays.toString(cmdToRunWithArgs));
            AnsiLog.trace(e);
            ArrayList<String> arrayList = new ArrayList<String>(0);
            return arrayList;
        }
        catch (InterruptedException ie) {
            AnsiLog.trace("Problem reading output from {}:", Arrays.toString(cmdToRunWithArgs));
            AnsiLog.trace(ie);
            Thread.currentThread().interrupt();
        }
        finally {
            IOUtils.close(reader);
        }
        return sa;
    }

    public static String getFirstAnswer(String cmd2launch) {
        return ExecutingCommand.getAnswerAt(cmd2launch, 0);
    }

    public static String getAnswerAt(String cmd2launch, int answerIdx) {
        List<String> sa = ExecutingCommand.runNative(cmd2launch);
        if (answerIdx >= 0 && answerIdx < sa.size()) {
            return sa.get(answerIdx);
        }
        return "";
    }
}

