/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.boot;

import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.ExecutingCommand;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.common.JavaVersionUtils;
import com.taobao.arthas.common.PidUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class ProcessUtils {
    private static String FOUND_JAVA_HOME = null;

    public static int select(boolean v, int telnetPortPid) throws InputMismatchException {
        Object processMap = ProcessUtils.listProcessByJps(v);
        if (telnetPortPid > 0 && processMap.containsKey(telnetPortPid)) {
            String telnetPortProcess = processMap.get(telnetPortPid);
            processMap.remove(telnetPortPid);
            LinkedHashMap newProcessMap = new LinkedHashMap();
            newProcessMap.put(telnetPortPid, telnetPortProcess);
            newProcessMap.putAll(processMap);
            processMap = newProcessMap;
        }
        if (processMap.isEmpty()) {
            AnsiLog.info((String)"Can not find java process. Try to pass <pid> in command line.");
            return -1;
        }
        AnsiLog.info((String)"Found existing java process, please choose one and hit RETURN.");
        int count = 1;
        for (String process : processMap.values()) {
            if (count == 1) {
                System.out.println("* [" + count + "]: " + process);
            } else {
                System.out.println("  [" + count + "]: " + process);
            }
            ++count;
        }
        String line = new Scanner(System.in).nextLine();
        if (line.trim().isEmpty()) {
            return processMap.keySet().iterator().next();
        }
        int choice = new Scanner(line).nextInt();
        if (choice <= 0 || choice > processMap.size()) {
            return -1;
        }
        Iterator idIter = processMap.keySet().iterator();
        for (int i = 1; i <= choice; ++i) {
            if (i == choice) {
                return (Integer)idIter.next();
            }
            idIter.next();
        }
        return -1;
    }

    private static Map<Integer, String> listProcessByJps(boolean v) {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        String jps = "jps";
        File jpsFile = ProcessUtils.findJps();
        if (jpsFile != null) {
            jps = jpsFile.getAbsolutePath();
        }
        AnsiLog.debug((String)("Try use jps to lis java process, jps: " + jps));
        String[] command = null;
        command = v ? new String[]{jps, "-v", "-l"} : new String[]{jps, "-l"};
        List lines = ExecutingCommand.runNative((String[])command);
        int currentPid = Integer.parseInt(PidUtils.currentPid());
        for (String line : lines) {
            int pid;
            String[] strings = line.trim().split("\\s+");
            if (strings.length < 1 || (pid = Integer.parseInt(strings[0])) == currentPid || strings.length >= 2 && ProcessUtils.isJpsProcess(strings[1])) continue;
            result.put(pid, line);
        }
        return result;
    }

    public static String findJavaHome() {
        if (FOUND_JAVA_HOME != null) {
            return FOUND_JAVA_HOME;
        }
        String javaHome = System.getProperty("java.home");
        if (JavaVersionUtils.isLessThanJava9()) {
            File toolsJar = new File(javaHome, "lib/tools.jar");
            if (!toolsJar.exists()) {
                toolsJar = new File(javaHome, "../lib/tools.jar");
            }
            if (!toolsJar.exists()) {
                toolsJar = new File(javaHome, "../../lib/tools.jar");
            }
            if (toolsJar.exists()) {
                FOUND_JAVA_HOME = javaHome;
                return FOUND_JAVA_HOME;
            }
            if (!toolsJar.exists()) {
                AnsiLog.debug((String)("Can not find tools.jar under java.home: " + javaHome));
                String javaHomeEnv = System.getenv("JAVA_HOME");
                if (javaHomeEnv != null && !javaHomeEnv.isEmpty()) {
                    AnsiLog.debug((String)("Try to find tools.jar in System Env JAVA_HOME: " + javaHomeEnv));
                    toolsJar = new File(javaHomeEnv, "lib/tools.jar");
                    if (!toolsJar.exists()) {
                        toolsJar = new File(javaHomeEnv, "../lib/tools.jar");
                    }
                }
                if (toolsJar.exists()) {
                    AnsiLog.info((String)("Found java home from System Env JAVA_HOME: " + javaHomeEnv));
                    FOUND_JAVA_HOME = javaHomeEnv;
                    return FOUND_JAVA_HOME;
                }
                throw new IllegalArgumentException("Can not find tools.jar under java home: " + javaHome + ", please try to start arthas-boot with full path java. Such as /opt/jdk/bin/java -jar arthas-boot.jar");
            }
        } else {
            FOUND_JAVA_HOME = javaHome;
        }
        return FOUND_JAVA_HOME;
    }

    public static void startArthasCore(int targetPid, List<String> attachArgs) {
        String javaHome = ProcessUtils.findJavaHome();
        File javaPath = ProcessUtils.findJava();
        if (javaPath == null) {
            throw new IllegalArgumentException("Can not find java/java.exe executable file under java home: " + javaHome);
        }
        File toolsJar = ProcessUtils.findToolsJar();
        if (JavaVersionUtils.isLessThanJava9() && (toolsJar == null || !toolsJar.exists())) {
            throw new IllegalArgumentException("Can not find tools.jar under java home: " + javaHome);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaPath.getAbsolutePath());
        if (toolsJar != null && toolsJar.exists()) {
            command.add("-Xbootclasspath/a:" + toolsJar.getAbsolutePath());
        }
        command.addAll(attachArgs);
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            final Process proc = pb.start();
            Thread redirectStdout = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getInputStream();
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        IOUtils.close((InputStream)inputStream);
                    }
                }
            });
            Thread redirectStderr = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getErrorStream();
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)System.err);
                    }
                    catch (IOException e) {
                        IOUtils.close((InputStream)inputStream);
                    }
                }
            });
            redirectStdout.start();
            redirectStderr.start();
            redirectStdout.join();
            redirectStderr.join();
            int exitValue = proc.exitValue();
            if (exitValue != 0) {
                AnsiLog.error((String)("attach fail, targetPid: " + targetPid));
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static File findJava() {
        String javaHome = ProcessUtils.findJavaHome();
        String[] paths = new String[]{"bin/java", "bin/java.exe", "../bin/java", "../bin/java.exe"};
        ArrayList<File> javaList = new ArrayList<File>();
        for (String path : paths) {
            File javaFile = new File(javaHome, path);
            if (!javaFile.exists()) continue;
            AnsiLog.debug((String)("Found java: " + javaFile.getAbsolutePath()));
            javaList.add(javaFile);
        }
        if (javaList.isEmpty()) {
            AnsiLog.debug((String)("Can not find java/java.exe under current java home: " + javaHome));
            return null;
        }
        if (javaList.size() > 1) {
            Collections.sort(javaList, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    try {
                        return file1.getCanonicalPath().length() - file2.getCanonicalPath().length();
                    }
                    catch (IOException iOException) {
                        return -1;
                    }
                }
            });
        }
        return (File)javaList.get(0);
    }

    private static File findToolsJar() {
        if (JavaVersionUtils.isGreaterThanJava8()) {
            return null;
        }
        String javaHome = ProcessUtils.findJavaHome();
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(javaHome, "../lib/tools.jar");
        }
        if (!toolsJar.exists()) {
            toolsJar = new File(javaHome, "../../lib/tools.jar");
        }
        if (!toolsJar.exists()) {
            throw new IllegalArgumentException("Can not find tools.jar under java home: " + javaHome);
        }
        AnsiLog.debug((String)("Found tools.jar: " + toolsJar.getAbsolutePath()));
        return toolsJar;
    }

    private static File findJps() {
        String javaHome = System.getProperty("java.home");
        String[] paths = new String[]{"bin/jps", "bin/jps.exe", "../bin/jps", "../bin/jps.exe"};
        ArrayList<File> jpsList = new ArrayList<File>();
        for (String path : paths) {
            File jpsFile = new File(javaHome, path);
            if (!jpsFile.exists()) continue;
            AnsiLog.debug((String)("Found jps: " + jpsFile.getAbsolutePath()));
            jpsList.add(jpsFile);
        }
        if (jpsList.isEmpty()) {
            AnsiLog.debug((String)("Can not find jps under :" + javaHome));
            String javaHomeEnv = System.getenv("JAVA_HOME");
            AnsiLog.debug((String)("Try to find jps under env JAVA_HOME :" + javaHomeEnv));
            for (String path : paths) {
                File jpsFile = new File(javaHomeEnv, path);
                if (!jpsFile.exists()) continue;
                AnsiLog.debug((String)("Found jps: " + jpsFile.getAbsolutePath()));
                jpsList.add(jpsFile);
            }
        }
        if (jpsList.isEmpty()) {
            AnsiLog.debug((String)("Can not find jps under current java home: " + javaHome));
            return null;
        }
        if (jpsList.size() > 1) {
            Collections.sort(jpsList, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    try {
                        return file1.getCanonicalPath().length() - file2.getCanonicalPath().length();
                    }
                    catch (IOException iOException) {
                        return -1;
                    }
                }
            });
        }
        return (File)jpsList.get(0);
    }

    private static boolean isJpsProcess(String mainClassName) {
        return "sun.tools.jps.Jps".equals(mainClassName) || "jdk.jcmd/sun.tools.jps.Jps".equals(mainClassName);
    }
}

