/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.devtools.inspector.network;

import android.support.annotation.Nullable;
import android.util.Log;
import com.taobao.weex.devtools.inspector.network.NetworkEventReporter;
import com.taobao.weex.devtools.inspector.network.ResponseHandler;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class NetworkEventReporterManager {
    private static final String DEFAULT_NETWORK_EVENT_REPORTER_IMPL_CLASS = "com.taobao.weex.devtools.inspector.network.NetworkEventReporterImpl";
    private static NetworkEventReporter sReporter = null;
    private static Map<String, Object> inspectParams;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static NetworkEventReporter get() {
        if (!NetworkEventReporterManager.allowReport()) return null;
        if (sReporter != null) return sReporter;
        Class<NetworkEventReporterManager> clazz = NetworkEventReporterManager.class;
        synchronized (NetworkEventReporterManager.class) {
            if (sReporter != null) return sReporter;
            try {
                Class<?> clazz2 = Class.forName(DEFAULT_NETWORK_EVENT_REPORTER_IMPL_CLASS);
                Method methodGet = clazz2.getMethod("get", new Class[0]);
                sReporter = (NetworkEventReporter)methodGet.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Log.w((String)"NetworkEventReporter", (Throwable)e);
            }
            return sReporter;
        }
    }

    public static void putParam(String key, Object value) {
        if (inspectParams == null) {
            inspectParams = new HashMap<String, Object>();
        }
        inspectParams.put(key, value);
    }

    public static <T> T getParam(String key, T defValue) {
        if (inspectParams == null) {
            return defValue;
        }
        return (T)inspectParams.get(key);
    }

    public static NetworkEventReporter newEmptyReporter() {
        return new NetworkEventReporterAdapter();
    }

    private static boolean allowReport() {
        try {
            Class<?> clazz = Class.forName("com.taobao.weex.WXEnvironment");
            Method method = clazz.getMethod("isApkDebugable", new Class[0]);
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)"NetworkEventReporter", (Throwable)e);
            return false;
        }
    }

    public static class NetworkEventReporterAdapter
    implements NetworkEventReporter {
        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void requestWillBeSent(NetworkEventReporter.InspectorRequest request) {
        }

        @Override
        public void responseHeadersReceived(NetworkEventReporter.InspectorResponse response) {
        }

        @Override
        public void httpExchangeFailed(String requestId, String errorText) {
        }

        @Override
        @Nullable
        public InputStream interpretResponseStream(String requestId, @Nullable String contentType, @Nullable String contentEncoding, @Nullable InputStream inputStream, ResponseHandler responseHandler) {
            return null;
        }

        @Override
        public void responseReadFailed(String requestId, String errorText) {
        }

        @Override
        public void responseReadFinished(String requestId) {
        }

        @Override
        public void dataSent(String requestId, int dataLength, int encodedDataLength) {
        }

        @Override
        public void dataReceived(String requestId, int dataLength, int encodedDataLength) {
        }

        @Override
        public String nextRequestId() {
            return null;
        }

        @Override
        public void webSocketCreated(String requestId, String url) {
        }

        @Override
        public void webSocketClosed(String requestId) {
        }

        @Override
        public void webSocketWillSendHandshakeRequest(NetworkEventReporter.InspectorWebSocketRequest request) {
        }

        @Override
        public void webSocketHandshakeResponseReceived(NetworkEventReporter.InspectorWebSocketResponse response) {
        }

        @Override
        public void webSocketFrameSent(NetworkEventReporter.InspectorWebSocketFrame frame) {
        }

        @Override
        public void webSocketFrameReceived(NetworkEventReporter.InspectorWebSocketFrame frame) {
        }

        @Override
        public void webSocketFrameError(String requestId, String errorMessage) {
        }
    }
}

