/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.taobao.weex.analyzer.view.chart.GridLabelRenderer;
import com.taobao.weex.analyzer.view.chart.LegendRenderer;
import com.taobao.weex.analyzer.view.chart.Series;
import com.taobao.weex.analyzer.view.chart.Viewport;
import java.util.ArrayList;
import java.util.List;

public class ChartView
extends View {
    private boolean isTouchEnabled = true;
    private List<Series> mSeries;
    private GridLabelRenderer mGridLabelRenderer;
    private Viewport mViewport;
    private String mTitle;
    private Styles mStyles;
    private TapDetector mTapDetector;
    private LegendRenderer mLegendRenderer;
    private Paint mPaintTitle;
    private Paint mPreviewPaint;

    public ChartView(Context context) {
        super(context);
        this.init();
    }

    public ChartView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ChartView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.mPreviewPaint = new Paint();
        this.mPreviewPaint.setTextAlign(Paint.Align.CENTER);
        this.mPreviewPaint.setColor(-16777216);
        this.mPreviewPaint.setTextSize(50.0f);
        this.mStyles = new Styles();
        this.mViewport = new Viewport(this);
        this.mGridLabelRenderer = new GridLabelRenderer(this);
        this.mLegendRenderer = new LegendRenderer(this);
        this.mSeries = new ArrayList<Series>();
        this.mPaintTitle = new Paint();
        this.mTapDetector = new TapDetector();
        this.loadStyles();
    }

    protected void loadStyles() {
        this.mStyles.titleColor = this.mGridLabelRenderer.getHorizontalLabelsColor();
        this.mStyles.titleTextSize = this.mGridLabelRenderer.getTextSize();
    }

    public GridLabelRenderer getGridLabelRenderer() {
        return this.mGridLabelRenderer;
    }

    public void addSeries(Series s) {
        s.onGraphViewAttached(this);
        this.mSeries.add(s);
        this.onDataChanged(false, false);
    }

    public List<Series> getSeries() {
        return this.mSeries;
    }

    public void onDataChanged(boolean keepLabelsSize, boolean keepViewport) {
        this.mViewport.calcCompleteRange();
        this.mGridLabelRenderer.invalidate(keepLabelsSize, keepViewport);
        this.postInvalidate();
    }

    protected void drawGraphElements(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 11 && !canvas.isHardwareAccelerated()) {
            Log.d((String)"ChartView", (String)"use android:hardwareAccelerated=\"true\" for better performance");
        }
        try {
            this.drawTitle(canvas);
            this.mViewport.drawFirst(canvas);
            this.mGridLabelRenderer.draw(canvas);
            for (Series s : this.mSeries) {
                s.draw(this, canvas);
            }
            this.mViewport.draw(canvas);
            this.mLegendRenderer.draw(canvas);
        }
        catch (Exception e) {
            Log.d((String)"ChartView", (String)e.getMessage());
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            canvas.drawColor(Color.rgb((int)200, (int)200, (int)200));
            canvas.drawText("GraphView: No Preview available", (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2), this.mPreviewPaint);
        } else {
            this.drawGraphElements(canvas);
        }
    }

    protected void drawTitle(Canvas canvas) {
        if (this.mTitle != null && this.mTitle.length() > 0) {
            this.mPaintTitle.setColor(this.mStyles.titleColor);
            this.mPaintTitle.setTextSize(this.mStyles.titleTextSize);
            this.mPaintTitle.setTextAlign(Paint.Align.CENTER);
            float x = canvas.getWidth() / 2;
            float y = this.mPaintTitle.getTextSize();
            canvas.drawText(this.mTitle, x, y, this.mPaintTitle);
        }
    }

    protected int getTitleHeight() {
        if (this.mTitle != null && this.mTitle.length() > 0) {
            return (int)this.mPaintTitle.getTextSize();
        }
        return 0;
    }

    public Viewport getViewport() {
        return this.mViewport;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onDataChanged(false, false);
    }

    public int getGraphContentLeft() {
        int border = this.getGridLabelRenderer().getStyles().padding;
        return border + this.getGridLabelRenderer().getLabelVerticalWidth() + this.getGridLabelRenderer().getVerticalAxisTitleWidth();
    }

    public int getGraphContentTop() {
        int border = this.getGridLabelRenderer().getStyles().padding + this.getTitleHeight();
        return border;
    }

    public int getGraphContentHeight() {
        int border = this.getGridLabelRenderer().getStyles().padding;
        int graphheight = this.getHeight() - 2 * border - this.getGridLabelRenderer().getLabelHorizontalHeight() - this.getTitleHeight();
        return graphheight -= this.getGridLabelRenderer().getHorizontalAxisTitleHeight();
    }

    public int getGraphContentWidth() {
        int border = this.getGridLabelRenderer().getStyles().padding;
        int graphwidth = this.getWidth() - 2 * border - this.getGridLabelRenderer().getLabelVerticalWidth();
        return graphwidth;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isTouchEnabled) {
            return false;
        }
        boolean b = this.mViewport.onTouchEvent(event);
        boolean a = super.onTouchEvent(event);
        if (this.mTapDetector.onTouchEvent(event)) {
            for (Series s : this.mSeries) {
                s.onTap(event.getX(), event.getY());
            }
        }
        return b || a;
    }

    public void setTouchEnabled(boolean isTouchEnabled) {
        this.isTouchEnabled = isTouchEnabled;
    }

    public boolean isTouchEnabled() {
        return this.isTouchEnabled;
    }

    public void computeScroll() {
        super.computeScroll();
        this.mViewport.computeScroll();
    }

    public LegendRenderer getLegendRenderer() {
        return this.mLegendRenderer;
    }

    public void setLegendRenderer(LegendRenderer mLegendRenderer) {
        this.mLegendRenderer = mLegendRenderer;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String mTitle) {
        this.mTitle = mTitle;
    }

    public float getTitleTextSize() {
        return this.mStyles.titleTextSize;
    }

    public void setTitleTextSize(float titleTextSize) {
        this.mStyles.titleTextSize = titleTextSize;
    }

    public int getTitleColor() {
        return this.mStyles.titleColor;
    }

    public void setTitleColor(int titleColor) {
        this.mStyles.titleColor = titleColor;
    }

    public void removeAllSeries() {
        this.mSeries.clear();
        this.onDataChanged(false, false);
    }

    public void removeSeries(Series<?> series) {
        this.mSeries.remove(series);
        this.onDataChanged(false, false);
    }

    private class TapDetector {
        private long lastDown;
        private PointF lastPoint;

        private TapDetector() {
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (event.getAction() == 0) {
                this.lastDown = System.currentTimeMillis();
                this.lastPoint = new PointF(event.getX(), event.getY());
            } else if (this.lastDown > 0L && event.getAction() == 2) {
                if (Math.abs(event.getX() - this.lastPoint.x) > 60.0f || Math.abs(event.getY() - this.lastPoint.y) > 60.0f) {
                    this.lastDown = 0L;
                }
            } else if (event.getAction() == 1 && System.currentTimeMillis() - this.lastDown < 400L) {
                return true;
            }
            return false;
        }
    }

    private static final class Styles {
        float titleTextSize;
        int titleColor;

        private Styles() {
        }
    }
}

