/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.StorageHacker;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.view.AbstractAlertView;
import com.taobao.weex.analyzer.view.CompatibleAlertDialogBuilder;
import java.util.ArrayList;
import java.util.List;

public class StorageView
extends AbstractAlertView {
    private PerformanceViewAdapter mAdapter;
    private StorageHacker mStorageHacker;
    private RecyclerView mStorageList;

    public StorageView(Context context) {
        super(context);
    }

    @Override
    protected void onShown() {
        if (this.mStorageHacker == null || this.mStorageHacker.isDestroy()) {
            this.mStorageHacker = new StorageHacker(this.getContext(), SDKUtils.isDebugMode(this.getContext()));
        }
        this.mStorageHacker.fetch(new StorageHacker.OnLoadListener(){

            @Override
            public void onLoad(List<StorageHacker.StorageInfo> list) {
                if (StorageView.this.mAdapter == null) {
                    StorageView.this.mAdapter = new PerformanceViewAdapter(StorageView.this.getContext(), list);
                    StorageView.this.mStorageList.setAdapter((RecyclerView.Adapter)StorageView.this.mAdapter);
                } else {
                    StorageView.this.mAdapter.refreshData(list);
                }
            }
        });
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
        if (this.mStorageHacker != null) {
            this.mStorageHacker.destroy();
        }
    }

    @Override
    protected void onInitView(@NonNull Window window) {
        window.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StorageView.this.dismiss();
            }
        });
        this.mStorageList = (RecyclerView)window.findViewById(R.id.list);
        this.mStorageList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        ArrayList<StorageHacker.StorageInfo> empty = new ArrayList<StorageHacker.StorageInfo>(6);
        this.mAdapter = new PerformanceViewAdapter(this.getContext(), empty);
        this.mStorageList.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.wxt_storage_view;
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mKeyText;
        private TextView mValueText;
        private TextView mTimestampText;
        private StorageHacker.StorageInfo mCurStorageInfo;
        private OnItemLongClickListener mListener;

        ViewHolder(View itemView) {
            super(itemView);
            this.mKeyText = (TextView)itemView.findViewById(R.id.key);
            this.mValueText = (TextView)itemView.findViewById(R.id.value);
            this.mTimestampText = (TextView)itemView.findViewById(R.id.timestamp);
            itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (ViewHolder.this.mListener != null) {
                        try {
                            int pos = ViewHolder.this.getAdapterPosition();
                            if (ViewHolder.this.mCurStorageInfo != null && ((ViewHolder)ViewHolder.this).mCurStorageInfo.key != null) {
                                ViewHolder.this.mListener.onItemClick(pos, ((ViewHolder)ViewHolder.this).mCurStorageInfo.key);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
            });
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ViewHolder.this.mCurStorageInfo != null && !TextUtils.isEmpty((CharSequence)((ViewHolder)ViewHolder.this).mCurStorageInfo.value)) {
                        Toast.makeText((Context)v.getContext(), (CharSequence)((ViewHolder)ViewHolder.this).mCurStorageInfo.value, (int)1).show();
                    }
                }
            });
        }

        void bind(@NonNull StorageHacker.StorageInfo info, boolean flag) {
            this.mCurStorageInfo = info;
            this.itemView.setBackgroundColor(flag ? Color.parseColor((String)"#E0E0E0") : -1);
            this.mValueText.setText((CharSequence)info.value);
            this.mKeyText.setText((CharSequence)info.key);
            this.mTimestampText.setText((CharSequence)info.timestamp);
        }

        void setOnItemLongClickListener(OnItemLongClickListener listener) {
            this.mListener = listener;
        }

        static interface OnItemLongClickListener {
            public void onItemClick(int var1, String var2);
        }
    }

    private class PerformanceViewAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private Context mContext;
        private List<StorageHacker.StorageInfo> mStorageData;

        PerformanceViewAdapter(@NonNull Context context, List<StorageHacker.StorageInfo> data) {
            this.mContext = context;
            this.mStorageData = data;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.wxt_item_storage, parent, false);
            ViewHolder holder = new ViewHolder(view);
            holder.setOnItemLongClickListener(new ViewHolder.OnItemLongClickListener(){

                @Override
                public void onItemClick(final int position, final String key) {
                    CompatibleAlertDialogBuilder builder = new CompatibleAlertDialogBuilder(PerformanceViewAdapter.this.mContext);
                    builder.setTitle("Alert");
                    builder.setMessage("remove key (" + key + ") from weex storage ?");
                    builder.setPositiveButton("yes", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            if (StorageView.this.mStorageHacker != null && key != null) {
                                StorageView.this.mStorageHacker.remove(key, new StorageHacker.OnRemoveListener(){

                                    @Override
                                    public void onRemoved(boolean status) {
                                        if (status) {
                                            PerformanceViewAdapter.this.mStorageData.remove(position);
                                            PerformanceViewAdapter.this.notifyDataSetChanged();
                                            if (PerformanceViewAdapter.this.mContext != null) {
                                                Toast.makeText((Context)PerformanceViewAdapter.this.mContext, (CharSequence)"remove success", (int)0).show();
                                            }
                                        } else if (PerformanceViewAdapter.this.mContext != null) {
                                            Toast.makeText((Context)PerformanceViewAdapter.this.mContext, (CharSequence)"remove failed", (int)0).show();
                                        }
                                    }
                                });
                            }
                            dialog.dismiss();
                        }
                    });
                    builder.setNegativeButton("no", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    builder.create().show();
                }
            });
            return holder;
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (holder instanceof ViewHolder) {
                StorageHacker.StorageInfo info = this.mStorageData.get(position);
                ((ViewHolder)holder).bind(info, position % 2 != 0);
            }
        }

        public int getItemCount() {
            if (this.mStorageData == null) {
                return 0;
            }
            return this.mStorageData.size();
        }

        void refreshData(@NonNull List<StorageHacker.StorageInfo> list) {
            this.mStorageData.clear();
            this.mStorageData.addAll(list);
            this.notifyDataSetChanged();
        }
    }
}

