/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TextView;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.IOverlayView;

public class SimpleOverlayView
extends DragSupportOverlayView {
    private OnClickListener mOnClickListener;
    private String mTitle;
    private int mBackgroundColor = Color.parseColor((String)"#ba000000");
    private int mTextColor = -1;

    private SimpleOverlayView(Context application, @NonNull String title) {
        super(application);
        this.mTitle = title;
        this.mWidth = (int)ViewUtils.dp2px(this.mContext, 40);
        this.mHeight = (int)ViewUtils.dp2px(this.mContext, 25);
    }

    void setOnClickListener(@Nullable OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        TextView textView = new TextView(this.mContext);
        textView.setTextColor(this.mTextColor);
        textView.setBackgroundColor(this.mBackgroundColor);
        textView.setGravity(17);
        textView.setText((CharSequence)this.mTitle);
        if (this.mOnClickListener != null) {
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SimpleOverlayView.this.mOnClickListener.onClick(SimpleOverlayView.this);
                }
            });
        }
        return textView;
    }

    @Override
    protected void onShown() {
    }

    @Override
    protected void onDismiss() {
    }

    public static class Builder {
        String title;
        Context context;
        int backgroundColor = Color.parseColor((String)"#ba000000");
        int textColor = -1;
        int x;
        int y;
        int width;
        int height;
        int gravity;
        OnClickListener listener;
        boolean enableDrag = true;

        public Builder(@NonNull Context context, @NonNull String title) {
            this.context = context;
            this.title = title;
        }

        public Builder backgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder textColor(int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder x(int x) {
            this.x = x;
            return this;
        }

        public Builder y(int y) {
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder listener(OnClickListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder enableDrag(boolean enableDrag) {
            this.enableDrag = enableDrag;
            return this;
        }

        public SimpleOverlayView build() {
            SimpleOverlayView overlayView = new SimpleOverlayView(this.context, this.title);
            if (this.listener != null) {
                overlayView.setOnClickListener(this.listener);
            }
            if (this.gravity != 0) {
                overlayView.mGravity = this.gravity;
            }
            if (this.x > 0) {
                overlayView.mX = this.x;
            }
            if (this.y > 0) {
                overlayView.mY = this.y;
            }
            if (this.width > 0) {
                overlayView.mWidth = this.width;
            }
            if (this.height > 0) {
                overlayView.mHeight = this.height;
            }
            overlayView.mBackgroundColor = this.backgroundColor;
            overlayView.mTextColor = this.textColor;
            overlayView.setDragEnabled(this.enableDrag);
            return overlayView;
        }
    }

    public static interface OnClickListener {
        public void onClick(@NonNull IOverlayView var1);
    }
}

