/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.view.CompatibleAlertDialogBuilder;
import com.taobao.weex.bridge.WXBridgeManager;
import java.lang.reflect.Method;
import java.util.Locale;

public class RemoteDebugManager {
    private static RemoteDebugManager sManager;
    private boolean isEnabled = false;
    private static final String sRemoteUrlTemplate = "ws://%s:8088/debugProxy/native";
    private String mServerIP = null;

    private RemoteDebugManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RemoteDebugManager getInstance() {
        if (sManager != null) return sManager;
        Class<RemoteDebugManager> clazz = RemoteDebugManager.class;
        synchronized (RemoteDebugManager.class) {
            if (sManager != null) return sManager;
            sManager = new RemoteDebugManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sManager;
        }
    }

    public void toggle(Context context) {
        try {
            boolean bl = this.isEnabled = !this.isEnabled;
            if (this.isEnabled) {
                this.startRemoteJSDebug(context);
            } else {
                this.stopRemoteJSDebug(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void requestDebugServer(final Context context, final boolean autoStart) {
        CompatibleAlertDialogBuilder builder = new CompatibleAlertDialogBuilder(context);
        final EditText editText = new EditText(context);
        if (!TextUtils.isEmpty((CharSequence)this.mServerIP)) {
            editText.setHint((CharSequence)this.mServerIP);
        } else {
            editText.setHint((CharSequence)"127.0.0.1");
        }
        builder.setView((View)editText);
        builder.setTitle("Debug server ip configuration");
        builder.setPositiveButton("Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        final AlertDialog dialog = builder.create();
        dialog.show();
        dialog.getButton(-1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String temp = editText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)temp)) {
                    Toast.makeText((Context)context, (CharSequence)"ip can not be null", (int)0).show();
                } else {
                    RemoteDebugManager.this.mServerIP = temp.trim();
                    dialog.dismiss();
                    if (autoStart) {
                        RemoteDebugManager.this.startRemoteJSDebug(context);
                    }
                }
            }
        });
    }

    private void startRemoteJSDebug(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.mServerIP)) {
                this.requestDebugServer(context, true);
                this.isEnabled = false;
                return;
            }
            WXEnvironment.sRemoteDebugProxyUrl = String.format(Locale.CHINA, sRemoteUrlTemplate, this.mServerIP);
            WXSDKEngine.reload();
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.wxt_opened), (int)0).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopRemoteJSDebug(Context context) {
        try {
            WXBridgeManager manager = WXBridgeManager.getInstance();
            Method method = manager.getClass().getDeclaredMethod("stopRemoteDebug", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)manager, new Object[0]);
            Toast.makeText((Context)context, (CharSequence)"close success", (int)0).show();
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)context, (CharSequence)"close failed", (int)0).show();
        }
    }
}

