/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.support.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.IVDomMonitor;
import com.taobao.weex.analyzer.core.VDomTracker;
import com.taobao.weex.analyzer.pojo.HealthReport;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.ref.WeakReference;

public class PollingVDomMonitor
implements IVDomMonitor {
    private PollingTask mTask;
    static boolean shouldStop;

    @Override
    public void monitor(@NonNull WXSDKInstance instance) {
        if (this.mTask != null) {
            this.mTask.stop();
        }
        this.mTask = new PollingTask(instance);
        this.mTask.start();
    }

    @Override
    public void destroy() {
        if (this.mTask != null) {
            this.mTask.stop();
        }
    }

    private static class PollingTask
    extends AbstractLoopTask {
        private WeakReference<WXSDKInstance> instanceRef;

        PollingTask(WXSDKInstance instance) {
            super(false, 1500);
            this.instanceRef = new WeakReference<WXSDKInstance>(instance);
        }

        @Override
        protected void onRun() {
            if (shouldStop) {
                WXLogUtils.e((String)"weex-analyzer", (String)"polling service is destroyed");
                this.stop();
                return;
            }
            WXSDKInstance instance = (WXSDKInstance)this.instanceRef.get();
            if (instance == null) {
                WXLogUtils.e((String)"weex-analyzer", (String)"weex instance is destroyed");
                this.stop();
                return;
            }
            if (!(instance.getContext() == null || SDKUtils.isHostRunning(instance.getContext()) && SDKUtils.isInteractive(instance.getContext()))) {
                WXLogUtils.e((String)"weex-analyzer", (String)"polling service is destroyed because we are in background or killed");
                this.stop();
                return;
            }
            try {
                VDomTracker tracker = new VDomTracker(instance);
                HealthReport report = tracker.traverse();
                if (report != null) {
                    report.writeToConsole();
                }
            }
            catch (Exception e) {
                WXLogUtils.e((String)e.getMessage());
            }
        }

        @Override
        protected void onStop() {
        }
    }
}

