/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LifecycleAwareUtil
implements Application.ActivityLifecycleCallbacks {
    private static LifecycleAwareUtil sInstance = null;
    private boolean foreground = false;
    private boolean paused = true;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private Runnable check;
    private Handler handler = new Handler();
    private static final String TAG = "LifecycleAwareUtil";

    public static LifecycleAwareUtil init(@NonNull Context context) {
        if (sInstance == null) {
            sInstance = new LifecycleAwareUtil();
            if (context instanceof Application) {
                ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sInstance);
            } else if (context.getApplicationContext() instanceof Application) {
                ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sInstance);
            } else {
                throw new IllegalStateException("LifecycleAwareUtil is not initialised.[can't obtain application object]");
            }
        }
        return sInstance;
    }

    public static LifecycleAwareUtil get() {
        if (sInstance == null) {
            throw new IllegalStateException("LifecycleAwareUtil is not initialised.");
        }
        return sInstance;
    }

    public static void destroy(@NonNull Context context) {
        if (sInstance == null) {
            return;
        }
        sInstance.removeAllListeners();
        if (context instanceof Application) {
            ((Application)context).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sInstance);
        } else if (context.getApplicationContext() instanceof Application) {
            ((Application)context.getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sInstance);
        }
        sInstance = null;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Log.d((String)TAG, (String)("onActivityCreated," + activity.getClass().getSimpleName()));
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        Log.d((String)TAG, (String)("onActivityResumed," + activity.getClass().getSimpleName()));
        this.paused = false;
        boolean wasBackground = !this.foreground;
        this.foreground = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (wasBackground) {
            for (Listener l : this.listeners) {
                try {
                    l.onPageForeground();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Listener threw exception!", (Throwable)e);
                }
            }
        }
    }

    public void onActivityPaused(Activity activity) {
        Log.d((String)TAG, (String)("onActivityPaused," + activity.getClass().getSimpleName()));
        this.paused = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.check = new Runnable(){

            @Override
            public void run() {
                if (LifecycleAwareUtil.this.foreground && LifecycleAwareUtil.this.paused) {
                    LifecycleAwareUtil.this.foreground = false;
                    for (Listener l : LifecycleAwareUtil.this.listeners) {
                        try {
                            l.onPageBackground();
                        }
                        catch (Exception exc) {
                            Log.e((String)LifecycleAwareUtil.TAG, (String)"Listener threw exception!", (Throwable)exc);
                        }
                    }
                }
            }
        };
        this.handler.post(this.check);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        Log.d((String)TAG, (String)("onActivityDestroyed," + activity.getClass().getSimpleName()));
    }

    public static interface Listener {
        public void onPageForeground();

        public void onPageBackground();
    }
}

