/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.taobao.weex.analyzer.core.CpuSampler;
import com.taobao.weex.analyzer.core.TaskEntity;

public class CpuTaskEntity
implements TaskEntity<CpuInfo> {
    private long mTotalCpuTimeLast = 0L;
    private long mPidTotalCpuTimeLast = 0L;
    private long mPidUserCpuTimeLast = 0L;
    private long mPidKernelCpuTimeLast = 0L;
    private CpuInfo mCachedCpuInfo;

    @Override
    public void onTaskInit() {
        this.mTotalCpuTimeLast = 0L;
        this.mPidTotalCpuTimeLast = 0L;
        this.mPidUserCpuTimeLast = 0L;
        this.mPidKernelCpuTimeLast = 0L;
        this.mCachedCpuInfo = new CpuInfo();
    }

    @Override
    @NonNull
    public CpuInfo onTaskRun() {
        double pidCpuUsage;
        double pidKernelCpuUsage;
        double pidUserCpuUsage;
        String pidCpuRate = CpuSampler.samplePidCpuRate();
        String totalCpuRate = CpuSampler.sampleCpuRate();
        if (this.mCachedCpuInfo == null) {
            this.mCachedCpuInfo = new CpuInfo();
        }
        if (TextUtils.isEmpty((CharSequence)pidCpuRate) || TextUtils.isEmpty((CharSequence)totalCpuRate)) {
            this.mCachedCpuInfo.pidCpuUsage = 0.0;
            this.mCachedCpuInfo.pidKernelCpuUsage = 0.0;
            this.mCachedCpuInfo.pidUserCpuUsage = 0.0;
            return this.mCachedCpuInfo;
        }
        String[] cpuInfoArray = totalCpuRate.split(" ");
        if (cpuInfoArray.length < 9) {
            this.mCachedCpuInfo.pidCpuUsage = 0.0;
            this.mCachedCpuInfo.pidKernelCpuUsage = 0.0;
            this.mCachedCpuInfo.pidUserCpuUsage = 0.0;
            return this.mCachedCpuInfo;
        }
        String[] pidCpuInfoList = pidCpuRate.split(" ");
        if (pidCpuInfoList.length < 17) {
            this.mCachedCpuInfo.pidCpuUsage = 0.0;
            this.mCachedCpuInfo.pidKernelCpuUsage = 0.0;
            this.mCachedCpuInfo.pidUserCpuUsage = 0.0;
            return this.mCachedCpuInfo;
        }
        long user = Long.parseLong(cpuInfoArray[2]);
        long nice = Long.parseLong(cpuInfoArray[3]);
        long system = Long.parseLong(cpuInfoArray[4]);
        long idle = Long.parseLong(cpuInfoArray[5]);
        long ioWait = Long.parseLong(cpuInfoArray[6]);
        long hardIrq = Long.parseLong(cpuInfoArray[7]);
        long softIrq = Long.parseLong(cpuInfoArray[8]);
        long stealTime = Long.parseLong(cpuInfoArray[9]);
        long pidUTime = Long.parseLong(pidCpuInfoList[13]);
        long pidSTime = Long.parseLong(pidCpuInfoList[14]);
        long pidCUTime = Long.parseLong(pidCpuInfoList[15]);
        long pidCSTime = Long.parseLong(pidCpuInfoList[16]);
        long cpuTime = user + nice + system + idle + ioWait + hardIrq + softIrq + stealTime;
        long pidCpuTime = pidUTime + pidSTime + pidCUTime + pidCSTime;
        if (this.mTotalCpuTimeLast != 0L) {
            pidUserCpuUsage = (double)((pidUTime - this.mPidUserCpuTimeLast) * 100L) / (double)(cpuTime - this.mTotalCpuTimeLast);
            pidKernelCpuUsage = (double)((pidSTime - this.mPidKernelCpuTimeLast) * 100L) / (double)(cpuTime - this.mTotalCpuTimeLast);
            pidCpuUsage = pidUserCpuUsage + pidKernelCpuUsage;
        } else {
            pidCpuUsage = 0.0;
            pidUserCpuUsage = 0.0;
            pidKernelCpuUsage = 0.0;
        }
        this.mCachedCpuInfo.pidCpuUsage = Math.max(0.0, pidCpuUsage);
        this.mCachedCpuInfo.pidUserCpuUsage = Math.max(0.0, pidUserCpuUsage);
        this.mCachedCpuInfo.pidKernelCpuUsage = Math.max(0.0, pidKernelCpuUsage);
        this.mTotalCpuTimeLast = cpuTime;
        this.mPidTotalCpuTimeLast = pidCpuTime;
        this.mPidUserCpuTimeLast = pidUTime;
        this.mPidKernelCpuTimeLast = pidSTime;
        return this.mCachedCpuInfo;
    }

    @Override
    public void onTaskStop() {
        this.mTotalCpuTimeLast = 0L;
        this.mPidTotalCpuTimeLast = 0L;
        this.mPidUserCpuTimeLast = 0L;
        this.mPidKernelCpuTimeLast = 0L;
        this.mCachedCpuInfo = null;
    }

    public static class CpuInfo {
        public double pidCpuUsage;
        public double pidUserCpuUsage;
        public double pidKernelCpuUsage;
    }
}

