/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.Performance;
import com.taobao.weex.analyzer.view.AbstractBizItemView;
import com.taobao.weex.utils.WXViewUtils;
import java.util.List;

public class WXPerfItemView
extends AbstractBizItemView<Performance>
implements View.OnLongClickListener {
    private TextView totalTimeView;
    private TextView sdkVersionView;
    private TextView renderTimeView;
    private TextView sdkInitTime;
    private TextView networkTime;
    private RecyclerView mPerformanceList;

    public WXPerfItemView(Context context) {
        super(context);
    }

    public WXPerfItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WXPerfItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void prepareView() {
        this.totalTimeView = (TextView)this.findViewById(R.id.text_total_time);
        this.sdkVersionView = (TextView)this.findViewById(R.id.text_version_sdk);
        this.renderTimeView = (TextView)this.findViewById(R.id.text_screen_render_time);
        this.sdkInitTime = (TextView)this.findViewById(R.id.text_sdk_init_time);
        this.networkTime = (TextView)this.findViewById(R.id.text_network_time);
        this.totalTimeView.setOnLongClickListener((View.OnLongClickListener)this);
        this.renderTimeView.setOnLongClickListener((View.OnLongClickListener)this);
        this.sdkVersionView.setOnLongClickListener((View.OnLongClickListener)this);
        this.sdkInitTime.setOnLongClickListener((View.OnLongClickListener)this);
        this.networkTime.setOnLongClickListener((View.OnLongClickListener)this);
        this.mPerformanceList = (RecyclerView)this.findViewById(R.id.overlay_list);
        this.mPerformanceList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.wxt_panel_cur_perf_view;
    }

    @Override
    protected void inflateData(Performance data) {
        this.totalTimeView.setText((CharSequence)("totalTime : " + data.totalTime + "ms"));
        this.sdkVersionView.setText((CharSequence)("weex sdk version : " + data.WXSDKVersion + ""));
        this.renderTimeView.setText((CharSequence)("firstScreenRenderTime : " + data.screenRenderTime + "ms"));
        this.sdkInitTime.setText((CharSequence)("sdk init time : " + data.sdkInitTime + "ms(only once)"));
        this.networkTime.setText((CharSequence)("networkTime : " + data.networkTime + "ms"));
        PerformanceViewAdapter adapter = new PerformanceViewAdapter(this.getContext(), data);
        this.mPerformanceList.setAdapter((RecyclerView.Adapter)adapter);
    }

    public boolean onLongClick(View v) {
        Context context = v.getContext();
        if (context == null) {
            return false;
        }
        int id2 = v.getId();
        if (id2 == R.id.text_total_time) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.wxt_explain_total_time), (int)1).show();
        } else if (id2 == R.id.text_screen_render_time) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.wxt_explain_scr_time), (int)1).show();
        } else if (id2 == R.id.text_version_sdk) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.wxt_explain_wx_sdk_ver), (int)1).show();
        } else if (id2 == R.id.text_sdk_init_time) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.wxt_explain_sdk_init), (int)1).show();
        } else if (id2 == R.id.text_network_time) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.wxt_explain_network_time), (int)1).show();
        }
        return true;
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mValueText;

        ViewHolder(View itemView) {
            super(itemView);
            this.mValueText = (TextView)itemView;
        }

        void bind(@NonNull String value) {
            this.mValueText.setText((CharSequence)value);
        }
    }

    private static class PerformanceViewAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private Context mContext;
        private List<String> mValues;

        PerformanceViewAdapter(@NonNull Context context, @NonNull Performance performance) {
            this.mContext = context;
            this.mValues = this.transfer(performance);
        }

        private List<String> transfer(Performance performance) {
            return Performance.transfer(performance);
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ViewHolder(this.createItemView(this.mContext));
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (holder instanceof ViewHolder) {
                ((ViewHolder)holder).bind(this.mValues.get(position));
            }
        }

        public int getItemCount() {
            return this.mValues.size();
        }

        View createItemView(Context context) {
            int margin;
            TextView itemView = new TextView(context);
            RecyclerView.LayoutParams params = new RecyclerView.LayoutParams(-1, -2);
            params.topMargin = params.bottomMargin = (margin = WXViewUtils.dip2px((float)5.0f));
            itemView.setGravity(19);
            itemView.setTextSize(2, 14.0f);
            itemView.setLayoutParams((ViewGroup.LayoutParams)params);
            itemView.setTextColor(-16777216);
            return itemView;
        }
    }
}

