/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.widget.TextView;
import android.widget.Toast;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.Performance;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.AbstractBizItemView;
import com.taobao.weex.analyzer.view.chart.ChartView;
import com.taobao.weex.analyzer.view.chart.DataPoint;
import com.taobao.weex.analyzer.view.chart.DataPointInterface;
import com.taobao.weex.analyzer.view.chart.GridLabelRenderer;
import com.taobao.weex.analyzer.view.chart.LegendRenderer;
import com.taobao.weex.analyzer.view.chart.LineGraphSeries;
import com.taobao.weex.analyzer.view.chart.OnDataPointTapListener;
import com.taobao.weex.analyzer.view.chart.Series;
import com.taobao.weex.analyzer.view.chart.Viewport;
import java.util.List;
import java.util.Locale;

public class WXPerfHistoryItemView
extends AbstractBizItemView<List<Performance>>
implements OnDataPointTapListener {
    private ChartView mGraphView;
    private TextView mAverageVal;

    public WXPerfHistoryItemView(Context context) {
        super(context);
    }

    public WXPerfHistoryItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WXPerfHistoryItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void prepareView() {
        this.mGraphView = (ChartView)this.findViewById(R.id.chart);
        this.mAverageVal = (TextView)this.findViewById(R.id.average);
        GridLabelRenderer labelRenderer = this.mGraphView.getGridLabelRenderer();
        Viewport viewport = this.mGraphView.getViewport();
        viewport.setScalable(false);
        viewport.setScalableY(false);
        viewport.setScrollable(false);
        viewport.setScrollableY(false);
        this.mGraphView.setBackgroundColor(-1);
        labelRenderer.setHorizontalLabelsColor(-16777216);
        labelRenderer.setVerticalLabelsColor(-16777216);
        labelRenderer.setHorizontalAxisTitleColor(-16777216);
        labelRenderer.setVerticalAxisTitleColor(-16777216);
        this.mGraphView.setTitleColor(-16777216);
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.wxt_panel_history_perf_view;
    }

    @Override
    protected void inflateData(List<Performance> data) {
        int sampleSize = data.size();
        if (sampleSize == 0) {
            return;
        }
        double maxY = 480.0;
        int verticalPart = 8;
        DataPointInterface[] ctPoints = new DataPoint[sampleSize];
        DataPointInterface[] ttPoints = new DataPoint[sampleSize];
        DataPointInterface[] nwtPoints = new DataPoint[sampleSize];
        long fsrTotal = 0L;
        long ttTotal = 0L;
        long nwTotal = 0L;
        for (int i = 0; i < sampleSize; ++i) {
            Performance p = data.get(i);
            ctPoints[i] = new DataPoint(i, p.communicateTime);
            ttPoints[i] = new DataPoint(i, p.totalTime);
            nwtPoints[i] = new DataPoint(i, p.networkTime);
            maxY = Math.max(Math.max(p.totalTime, (double)p.networkTime), Math.max((double)p.communicateTime, maxY));
            fsrTotal += p.communicateTime;
            ttTotal = (long)((double)ttTotal + p.totalTime);
            nwTotal += p.networkTime;
        }
        Viewport viewport = this.mGraphView.getViewport();
        GridLabelRenderer labelRenderer = this.mGraphView.getGridLabelRenderer();
        labelRenderer.setHumanRounding(false);
        labelRenderer.setNumHorizontalLabels(sampleSize + 1);
        labelRenderer.setNumVerticalLabels(verticalPart + 1);
        viewport.setXAxisBoundsManual(true);
        viewport.setMinX(0.0);
        viewport.setMaxX(sampleSize);
        viewport.setYAxisBoundsManual(true);
        viewport.setMinY(0.0);
        viewport.setMaxY(ViewUtils.findSuitableVal(maxY, verticalPart));
        LineGraphSeries ctSeries = new LineGraphSeries(ctPoints);
        LineGraphSeries ttSeries = new LineGraphSeries(ttPoints);
        LineGraphSeries nwtSeries = new LineGraphSeries(nwtPoints);
        ctSeries.setTitle("communicateTime");
        ttSeries.setTitle("totalTime");
        nwtSeries.setTitle("networkTime");
        ctSeries.setOnDataPointTapListener(this);
        ttSeries.setOnDataPointTapListener(this);
        nwtSeries.setOnDataPointTapListener(this);
        ctSeries.setColor(Color.parseColor((String)"#E91E63"));
        ttSeries.setColor(Color.parseColor((String)"#9C27B0"));
        nwtSeries.setColor(Color.parseColor((String)"#CDDC39"));
        ctSeries.setDrawDataPoints(true);
        ttSeries.setDrawDataPoints(true);
        nwtSeries.setDrawDataPoints(true);
        ctSeries.setAnimated(true);
        ttSeries.setAnimated(true);
        nwtSeries.setAnimated(true);
        this.mGraphView.addSeries(ctSeries);
        this.mGraphView.addSeries(ttSeries);
        this.mGraphView.addSeries(nwtSeries);
        LegendRenderer legendRenderer = this.mGraphView.getLegendRenderer();
        legendRenderer.setVisible(true);
        legendRenderer.setBackgroundColor(0);
        legendRenderer.setAlign(LegendRenderer.LegendAlign.TOP);
        this.mAverageVal.setText((CharSequence)String.format(Locale.CHINA, this.getContext().getResources().getString(R.string.wxt_average), Float.valueOf((float)fsrTotal / (float)sampleSize), Float.valueOf((float)ttTotal / (float)sampleSize), Float.valueOf((float)nwTotal / (float)sampleSize)));
    }

    @Override
    public void onTap(Series series, DataPointInterface dataPoint) {
        Toast.makeText((Context)this.getContext(), (CharSequence)(series.getTitle() + "(" + dataPoint.getX() + "," + dataPoint.getY() + ")"), (int)0).show();
    }
}

