/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.FPSSampler;
import com.taobao.weex.analyzer.core.MemorySampler;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import java.util.Locale;

public class PerfSampleOverlayView
extends DragSupportOverlayView {
    private InvalidateUITask mTask;

    public PerfSampleOverlayView(Context application) {
        super(application);
    }

    @Override
    @NonNull
    protected View onCreateView() {
        View hostView = View.inflate((Context)this.mContext, (int)R.layout.wxt_perf_overlay_view, null);
        this.mX = (int)((float)this.mContext.getResources().getDisplayMetrics().widthPixels - ViewUtils.dp2px(this.mContext, 120));
        this.mY = (int)((float)this.mContext.getResources().getDisplayMetrics().heightPixels - ViewUtils.dp2px(this.mContext, 64));
        return hostView;
    }

    @Override
    protected void onShown() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
        this.mTask = new InvalidateUITask(this.mWholeView);
        this.mTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
    }

    private static class InvalidateUITask
    extends AbstractLoopTask {
        private TextView mMemoryText;
        private TextView mFpsValueText;
        private TextView mFrameSkippedText;
        private FPSSampler mFpsChecker;
        private int mTotalFrameDropped = 0;

        InvalidateUITask(@NonNull View hostView) {
            super(false);
            this.mDelayMillis = 1000;
            this.mFpsChecker = new FPSSampler();
            this.mMemoryText = (TextView)hostView.findViewById(R.id.memory_usage);
            this.mFpsValueText = (TextView)hostView.findViewById(R.id.fps_value);
            this.mFrameSkippedText = (TextView)hostView.findViewById(R.id.frame_skiped);
        }

        @Override
        protected void onStart() {
            super.onStart();
            if (this.mFpsChecker == null) {
                this.mFpsChecker = new FPSSampler();
            }
            this.mFpsChecker.reset();
            this.mFpsChecker.start();
        }

        @Override
        protected void onRun() {
            double fps;
            final double usedMemInMB = MemorySampler.getMemoryUsage();
            if (Build.VERSION.SDK_INT >= 16) {
                fps = this.mFpsChecker.getFPS();
                this.mTotalFrameDropped += Math.max(this.mFpsChecker.getExpectedNumFrames() - this.mFpsChecker.getNumFrames(), 0);
                this.mFpsChecker.reset();
            } else {
                fps = 0.0;
            }
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    InvalidateUITask.this.mMemoryText.setText((CharSequence)String.format(Locale.CHINA, "memory : %.2fMB", usedMemInMB));
                    if (Build.VERSION.SDK_INT >= 16) {
                        InvalidateUITask.this.mFpsValueText.setText((CharSequence)String.format(Locale.CHINA, "fps : %.2f", fps));
                        InvalidateUITask.this.mFrameSkippedText.setText((CharSequence)("" + InvalidateUITask.this.mTotalFrameDropped + " dropped so far"));
                    } else {
                        InvalidateUITask.this.mFpsValueText.setText((CharSequence)"fps : ??");
                        InvalidateUITask.this.mFrameSkippedText.setText((CharSequence)"?? dropped so far");
                    }
                }
            });
        }

        @Override
        protected void onStop() {
            this.mTotalFrameDropped = 0;
            this.mFpsChecker.stop();
            this.mFpsChecker = null;
        }
    }
}

