/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.LogcatDumpBuilder;
import com.taobao.weex.analyzer.core.LogcatDumper;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.CompatibleAlertDialogBuilder;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.SimpleOverlayView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LogView
extends DragSupportOverlayView {
    private LogcatDumper mLogcatDumper;
    private IOverlayView.OnCloseListener mOnCloseListener;
    private OnLogConfigChangedListener mConfigChangeListener;
    private onStatusChangedListener mStatusChangedListener;
    private SimpleOverlayView mCollapsedView;
    private static final Map<String, LogcatDumper.Rule> sDefaultRules = new HashMap<String, LogcatDumper.Rule>();
    private static final String FILTER_JS_LOG = "jsLog";
    private static final String FILTER_CALL_NATIVE = "callNative";
    private static final String FILTER_CALL_JS = "callJS";
    private static final String FILTER_ALL = "all";
    private static final String FILTER_EXCEPTION = "reportJSException";
    private static final String FILTER_CUSTOM = "custom";
    private int mLogLevel;
    private String mFilterName;
    private int mViewSize = 1;
    private LogListAdapter mLogAdapter;
    private boolean isSettingOpened;
    private boolean isSizeMenuOpened;
    private String mCurKeyword;

    public LogView(Context application) {
        super(application);
        this.mWidth = -1;
    }

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    public void setOnLogConfigChangedListener(@Nullable OnLogConfigChangedListener listener) {
        this.mConfigChangeListener = listener;
    }

    public void setOnStatusChangedListener(@Nullable onStatusChangedListener listener) {
        this.mStatusChangedListener = listener;
    }

    public void setLogLevel(int level) {
        this.mLogLevel = level;
    }

    public void setFilterName(String filterName) {
        this.mFilterName = filterName;
    }

    public void setViewSize(int size) {
        this.mViewSize = size;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        View wholeView = View.inflate((Context)this.mContext, (int)R.layout.wxt_log_view, null);
        final View hold = wholeView.findViewById(R.id.hold);
        View clear = wholeView.findViewById(R.id.clear);
        View close = wholeView.findViewById(R.id.close);
        View inputKeyword = wholeView.findViewById(R.id.btn_input_keyword);
        View clearKeyword = wholeView.findViewById(R.id.btn_clear_keyword);
        final TextView curKeyword = (TextView)wholeView.findViewById(R.id.text_cur_keyword);
        RadioGroup levelGroup = (RadioGroup)wholeView.findViewById(R.id.level_group);
        RadioGroup ruleGroup = (RadioGroup)wholeView.findViewById(R.id.rule_group);
        RadioGroup sizeGroup = (RadioGroup)wholeView.findViewById(R.id.height_group);
        TextView settings = (TextView)wholeView.findViewById(R.id.settings);
        View collapse = wholeView.findViewById(R.id.collapse);
        final ViewGroup settingContent = (ViewGroup)wholeView.findViewById(R.id.setting_content);
        final RecyclerView logList = (RecyclerView)wholeView.findViewById(R.id.list);
        TextView sizeBtn = (TextView)wholeView.findViewById(R.id.size);
        final ViewGroup sizeContent = (ViewGroup)wholeView.findViewById(R.id.size_content);
        sizeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogView.this.isSizeMenuOpened = !LogView.this.isSizeMenuOpened;
                if (LogView.this.isSizeMenuOpened) {
                    sizeContent.setVisibility(0);
                } else {
                    sizeContent.setVisibility(8);
                }
            }
        });
        settings.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogView.this.isSettingOpened = !LogView.this.isSettingOpened;
                if (LogView.this.isSettingOpened) {
                    settingContent.setVisibility(0);
                } else {
                    settingContent.setVisibility(8);
                }
            }
        });
        collapse.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogView.this.performCollapse();
            }
        });
        this.setLogSize(this.mViewSize, logList, false);
        switch (this.mViewSize) {
            case 0: {
                ((RadioButton)wholeView.findViewById(R.id.height_small)).setChecked(true);
                break;
            }
            case 1: {
                ((RadioButton)wholeView.findViewById(R.id.height_medium)).setChecked(true);
                break;
            }
            case 2: {
                ((RadioButton)wholeView.findViewById(R.id.height_large)).setChecked(true);
            }
        }
        sizeGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.height_small) {
                    LogView.this.mViewSize = 0;
                } else if (checkedId == R.id.height_medium) {
                    LogView.this.mViewSize = 1;
                } else if (checkedId == R.id.height_large) {
                    LogView.this.mViewSize = 2;
                }
                LogView.this.setLogSize(LogView.this.mViewSize, logList, true);
            }
        });
        inputKeyword.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View v) {
                final EditText editText = new EditText(v.getContext());
                editText.setTextColor(-16777216);
                LogView.this.mWholeView.setVisibility(8);
                new CompatibleAlertDialogBuilder(v.getContext()).setTitle("input keyword").setView((View)editText).setPositiveButton((CharSequence)"ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        LogView.this.mWholeView.setVisibility(0);
                        String text = editText.getText().toString();
                        if (TextUtils.isEmpty((CharSequence)text)) {
                            return;
                        }
                        LogView.this.mCurKeyword = text;
                        LogView.this.performSearch(LogView.this.mCurKeyword);
                        curKeyword.setText((CharSequence)String.format(Locale.CHINA, v.getContext().getString(R.string.wxt_current_keyword_format), LogView.this.mCurKeyword));
                        dialog.dismiss();
                    }
                }).setNegativeButton((CharSequence)"cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        LogView.this.mWholeView.setVisibility(0);
                        dialog.dismiss();
                    }
                }).setCancelable(false).create().show();
            }
        });
        clearKeyword.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogView.this.mCurKeyword = null;
                curKeyword.setText((CharSequence)String.format(Locale.CHINA, v.getContext().getString(R.string.wxt_current_keyword_format), ""));
                if (LogView.this.mLogcatDumper != null && LogView.this.mLogcatDumper.removeRule(LogView.FILTER_CUSTOM)) {
                    LogView.this.mLogcatDumper.findCachedLogByNewFilters();
                }
            }
        });
        logList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.mLogAdapter = new LogListAdapter(this.mContext, logList);
        logList.setAdapter((RecyclerView.Adapter)this.mLogAdapter);
        switch (this.mLogLevel) {
            case 2: {
                ((RadioButton)wholeView.findViewById(R.id.level_v)).setChecked(true);
                break;
            }
            case 4: {
                ((RadioButton)wholeView.findViewById(R.id.level_i)).setChecked(true);
                break;
            }
            case 3: {
                ((RadioButton)wholeView.findViewById(R.id.level_d)).setChecked(true);
                break;
            }
            case 5: {
                ((RadioButton)wholeView.findViewById(R.id.level_w)).setChecked(true);
                break;
            }
            case 6: {
                ((RadioButton)wholeView.findViewById(R.id.level_e)).setChecked(true);
            }
        }
        if (this.mFilterName == null) {
            this.mFilterName = FILTER_ALL;
        }
        switch (this.mFilterName) {
            case "all": {
                ((RadioButton)wholeView.findViewById(R.id.rule_all)).setChecked(true);
                break;
            }
            case "callJS": {
                ((RadioButton)wholeView.findViewById(R.id.rule_calljs)).setChecked(true);
                break;
            }
            case "callNative": {
                ((RadioButton)wholeView.findViewById(R.id.rule_callnative)).setChecked(true);
                break;
            }
            case "jsLog": {
                ((RadioButton)wholeView.findViewById(R.id.rule_jslog)).setChecked(true);
                break;
            }
            case "reportJSException": {
                ((RadioButton)wholeView.findViewById(R.id.rule_exception)).setChecked(true);
            }
        }
        levelGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (LogView.this.mLogcatDumper == null) {
                    return;
                }
                if (LogView.this.mLogAdapter != null) {
                    LogView.this.mLogAdapter.clear();
                }
                int level = LogView.this.mLogLevel;
                if (checkedId == R.id.level_i) {
                    level = 4;
                } else if (checkedId == R.id.level_v) {
                    level = 2;
                } else if (checkedId == R.id.level_d) {
                    level = 3;
                } else if (checkedId == R.id.level_e) {
                    level = 6;
                } else if (checkedId == R.id.level_w) {
                    level = 5;
                }
                if (level != LogView.this.mLogLevel) {
                    LogView.this.mLogLevel = level;
                    LogView.this.mLogcatDumper.setLevel(LogView.this.mLogLevel);
                    if (LogView.this.mConfigChangeListener != null) {
                        LogView.this.mConfigChangeListener.onLogLevelChanged(LogView.this.mLogLevel);
                    }
                }
                LogView.this.mLogcatDumper.findCachedLogByNewFilters();
            }
        });
        ruleGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (LogView.this.mLogcatDumper == null) {
                    return;
                }
                if (LogView.this.mLogAdapter != null) {
                    LogView.this.mLogAdapter.clear();
                }
                LogView.this.mLogcatDumper.removeAllRule();
                LogView.this.mCurKeyword = null;
                if (curKeyword != null) {
                    curKeyword.setText((CharSequence)String.format(Locale.CHINA, LogView.this.mContext.getString(R.string.wxt_current_keyword_format), ""));
                }
                String filterName = LogView.this.mFilterName;
                if (checkedId == R.id.rule_all) {
                    filterName = LogView.FILTER_ALL;
                } else if (checkedId == R.id.rule_jslog) {
                    filterName = LogView.FILTER_JS_LOG;
                    LogView.this.mLogcatDumper.addRule((LogcatDumper.Rule)sDefaultRules.get(LogView.FILTER_JS_LOG));
                } else if (checkedId == R.id.rule_calljs) {
                    filterName = LogView.FILTER_CALL_JS;
                    LogView.this.mLogcatDumper.addRule((LogcatDumper.Rule)sDefaultRules.get(LogView.FILTER_CALL_JS));
                } else if (checkedId == R.id.rule_callnative) {
                    filterName = LogView.FILTER_CALL_NATIVE;
                    LogView.this.mLogcatDumper.addRule((LogcatDumper.Rule)sDefaultRules.get(LogView.FILTER_CALL_NATIVE));
                } else if (checkedId == R.id.rule_exception) {
                    filterName = LogView.FILTER_EXCEPTION;
                    LogView.this.mLogcatDumper.addRule((LogcatDumper.Rule)sDefaultRules.get(LogView.FILTER_EXCEPTION));
                }
                if (!filterName.equals(LogView.this.mFilterName)) {
                    LogView.this.mFilterName = filterName;
                    if (LogView.this.mConfigChangeListener != null) {
                        LogView.this.mConfigChangeListener.onLogFilterChanged(LogView.this.mFilterName);
                    }
                }
                LogView.this.mLogcatDumper.findCachedLogByNewFilters();
            }
        });
        hold.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogView.this.mLogAdapter == null) {
                    return;
                }
                if (LogView.this.isViewAttached) {
                    if (LogView.this.mLogAdapter.isHoldModeEnabled()) {
                        LogView.this.mLogAdapter.setHoldModeEnabled(false);
                        ((TextView)hold).setText((CharSequence)"hold(off)");
                    } else {
                        LogView.this.mLogAdapter.setHoldModeEnabled(true);
                        ((TextView)hold).setText((CharSequence)"hold(on)");
                    }
                }
            }
        });
        clear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogView.this.isViewAttached && LogView.this.mLogAdapter != null) {
                    LogView.this.mLogAdapter.clear();
                    if (LogView.this.mLogcatDumper != null) {
                        LogView.this.mLogcatDumper.clearCachedLog();
                    }
                }
            }
        });
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogView.this.isViewAttached && LogView.this.mOnCloseListener != null) {
                    LogView.this.mOnCloseListener.close(LogView.this);
                    LogView.this.dismiss();
                }
            }
        });
        return wholeView;
    }

    @Override
    protected void onShown() {
        this.mLogcatDumper = new LogcatDumpBuilder().listener(new LogcatDumper.OnLogReceivedListener(){

            @Override
            public void onReceived(@NonNull List<LogcatDumper.LogInfo> logList) {
                if (LogView.this.mLogAdapter != null) {
                    LogView.this.mLogAdapter.addLog(logList);
                }
            }
        }).level(this.mLogLevel).enableCache(true).cacheLimit(1000).build();
        LogcatDumper.Rule rule = null;
        if (this.mFilterName != null) {
            rule = sDefaultRules.get(this.mFilterName);
        }
        if (rule != null) {
            this.mLogcatDumper.addRule(rule);
        }
        this.mLogcatDumper.beginDump();
    }

    @Override
    protected void onDismiss() {
        if (this.mLogcatDumper != null) {
            this.mLogcatDumper.destroy();
            this.mLogcatDumper = null;
        }
    }

    @Override
    protected void onDestroy() {
        if (this.mCollapsedView != null) {
            this.mCollapsedView.dismiss();
        }
    }

    private void performSearch(@Nullable String keyword) {
        if (TextUtils.isEmpty((CharSequence)keyword) || this.mLogcatDumper == null || this.mLogAdapter == null) {
            return;
        }
        this.mLogAdapter.clear();
        this.mLogcatDumper.removeRule(FILTER_CUSTOM);
        this.mLogcatDumper.addRule(new LogcatDumper.Rule(FILTER_CUSTOM, keyword));
        this.mLogcatDumper.findCachedLogByNewFilters();
    }

    private void performCollapse() {
        if (this.mStatusChangedListener != null) {
            this.mStatusChangedListener.onCollapsed();
        }
        this.dismiss();
        if (this.mCollapsedView == null) {
            this.mCollapsedView = new SimpleOverlayView.Builder(this.mContext, "Log").listener(new SimpleOverlayView.OnClickListener(){

                @Override
                public void onClick(@NonNull IOverlayView view) {
                    LogView.this.mCollapsedView.dismiss();
                    if (LogView.this.mStatusChangedListener != null) {
                        LogView.this.mStatusChangedListener.onExpanded();
                    }
                    LogView.this.show();
                }
            }).build();
        }
        this.mCollapsedView.show();
    }

    private void setLogSize(int size, RecyclerView logList, boolean allowFireEvent) {
        if (logList == null) {
            return;
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)logList.getLayoutParams();
        if (params == null) {
            return;
        }
        int heightSmall = (int)ViewUtils.dp2px(this.mContext, 200);
        int heightMedium = (int)ViewUtils.dp2px(this.mContext, 350);
        int heightLarge = -1;
        int height = params.height;
        switch (size) {
            case 0: {
                height = heightSmall;
                break;
            }
            case 1: {
                height = heightMedium;
                break;
            }
            case 2: {
                height = -1;
            }
        }
        if (height != params.height) {
            params.height = height;
            logList.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.mConfigChangeListener != null && allowFireEvent) {
                this.mConfigChangeListener.onLogSizeChanged(this.mViewSize);
            }
        }
    }

    static {
        sDefaultRules.put(FILTER_JS_LOG, new LogcatDumper.Rule(FILTER_JS_LOG, FILTER_JS_LOG));
        sDefaultRules.put(FILTER_CALL_NATIVE, new LogcatDumper.Rule(FILTER_CALL_NATIVE, FILTER_CALL_NATIVE));
        sDefaultRules.put(FILTER_CALL_JS, new LogcatDumper.Rule(FILTER_CALL_JS, FILTER_CALL_JS));
        sDefaultRules.put(FILTER_ALL, new LogcatDumper.Rule(FILTER_ALL, null));
        sDefaultRules.put(FILTER_EXCEPTION, new LogcatDumper.Rule(FILTER_EXCEPTION, FILTER_EXCEPTION));
    }

    private static class LogViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mText;
        private LogcatDumper.LogInfo mCurLog;

        LogViewHolder(View itemView) {
            super(itemView);
            this.mText = (TextView)itemView.findViewById(R.id.text_log);
            this.mText.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (LogViewHolder.this.mCurLog != null) {
                        try {
                            SDKUtils.copyToClipboard(v.getContext(), ((LogViewHolder)LogViewHolder.this).mCurLog.message, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
            });
        }

        void bind(LogcatDumper.LogInfo log) {
            this.mCurLog = log;
            switch (log.level) {
                case 2: {
                    this.mText.setTextColor(Color.parseColor((String)"#FFFFFF"));
                    break;
                }
                case 4: {
                    this.mText.setTextColor(Color.parseColor((String)"#2196F3"));
                    break;
                }
                case 3: {
                    this.mText.setTextColor(Color.parseColor((String)"#4CAF50"));
                    break;
                }
                case 5: {
                    this.mText.setTextColor(Color.parseColor((String)"#FFEB3B"));
                    break;
                }
                case 6: {
                    this.mText.setTextColor(Color.parseColor((String)"#F44336"));
                    break;
                }
                default: {
                    this.mText.setTextColor(Color.parseColor((String)"#FFFFFF"));
                }
            }
            this.mText.setText((CharSequence)log.message);
        }
    }

    private static class LogListAdapter
    extends RecyclerView.Adapter {
        private List<LogcatDumper.LogInfo> mLogData;
        private Context mContext;
        private boolean isHoldMode = false;
        private RecyclerView mList;

        LogListAdapter(@NonNull Context context, @NonNull RecyclerView list) {
            this.mContext = context;
            this.mLogData = new ArrayList<LogcatDumper.LogInfo>();
            this.mList = list;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.wxt_item_log, parent, false);
            return new LogViewHolder(itemView);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (holder instanceof LogViewHolder) {
                ((LogViewHolder)holder).bind(this.mLogData.get(position));
            }
        }

        public int getItemCount() {
            return this.mLogData.size();
        }

        void addLog(@NonNull LogcatDumper.LogInfo log) {
            this.mLogData.add(log);
            this.notifyItemInserted(this.mLogData.size());
        }

        void addLog(@NonNull List<LogcatDumper.LogInfo> list) {
            if (list.size() == 1) {
                this.addLog(list.get(0));
            } else {
                int size = this.mLogData.size();
                this.mLogData.addAll(list);
                this.notifyItemRangeInserted(size, list.size());
            }
            if (!this.isHoldMode) {
                try {
                    this.mList.smoothScrollToPosition(this.getItemCount() - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void clear() {
            this.mLogData.clear();
            this.notifyDataSetChanged();
        }

        void setHoldModeEnabled(boolean enabled) {
            this.isHoldMode = enabled;
        }

        boolean isHoldModeEnabled() {
            return this.isHoldMode;
        }
    }

    public static interface onStatusChangedListener {
        public void onCollapsed();

        public void onExpanded();
    }

    public static interface OnLogConfigChangedListener {
        public void onLogLevelChanged(int var1);

        public void onLogFilterChanged(String var1);

        public void onLogSizeChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Size {
        public static final int SMALL = 0;
        public static final int MEDIUM = 1;
        public static final int LARGE = 2;
    }
}

