/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import com.taobao.weex.analyzer.view.chart.ChartView;
import com.taobao.weex.analyzer.view.chart.DataPoint;
import com.taobao.weex.analyzer.view.chart.GridLabelRenderer;
import com.taobao.weex.analyzer.view.chart.LabelFormatter;
import com.taobao.weex.analyzer.view.chart.LineGraphSeries;
import com.taobao.weex.analyzer.view.chart.Viewport;

public class DynamicChartViewController {
    private ChartView mChartView;
    private int mMaxPoints;

    private DynamicChartViewController(ChartView chartView) {
        this.mChartView = chartView;
    }

    public void setMaxPoints(int maxPoints) {
        this.mMaxPoints = maxPoints;
    }

    public View getChartView() {
        return this.mChartView;
    }

    public void updateAxisY(double minY, double maxY, int numLabels) {
        if (this.mChartView == null) {
            return;
        }
        Viewport viewport = this.mChartView.getViewport();
        GridLabelRenderer render = this.mChartView.getGridLabelRenderer();
        viewport.setYAxisBoundsManual(true);
        if (numLabels > 0) {
            render.setNumVerticalLabels(numLabels);
        }
        viewport.setMinY(minY);
        viewport.setMaxY(maxY);
    }

    public void appendPointAndInvalidate(double x, double y) {
        LineGraphSeries series = (LineGraphSeries)this.mChartView.getSeries().get(0);
        series.appendData(new DataPoint(x, y), true, this.mMaxPoints);
    }

    public void appendPointAndInvalidate2(double x, double y) {
        if (this.mChartView.getSeries().size() >= 2) {
            LineGraphSeries series = (LineGraphSeries)this.mChartView.getSeries().get(1);
            series.appendData(new DataPoint(x, y), true, this.mMaxPoints);
        }
    }

    public double getMaxY() {
        if (this.mChartView == null) {
            return 0.0;
        }
        return this.mChartView.getViewport().getMaxY(false);
    }

    public double getMaxX() {
        if (this.mChartView == null) {
            return 0.0;
        }
        return this.mChartView.getViewport().getMaxX(false);
    }

    public double getMinX() {
        if (this.mChartView == null) {
            return 0.0;
        }
        return this.mChartView.getViewport().getMinX(false);
    }

    public double getMinY() {
        if (this.mChartView == null) {
            return 0.0;
        }
        return this.mChartView.getViewport().getMinY(false);
    }

    public static class Builder {
        private int mViewBackground = -16777216;
        private int mLabelColor = -1;
        private int mAxisColor = -1;
        private int mLineColor = -16711936;
        private int mFillColor = -16711936;
        private boolean isFill = false;
        private double mMinX = -1.0;
        private double mMinY = -1.0;
        private double mMaxX = -1.0;
        private double mMaxY = -1.0;
        private int mNumXLabels = 0;
        private int mNumYLabels = 0;
        private String mXAxisTitle = null;
        private String mYAxisTitle = null;
        private String mTitle;
        private LabelFormatter mLabelFormatter;
        private Context mContext;
        private int mMaxDataPoints = 0;
        private String mSeriesTitle;
        private String mSeries2Title;
        private int mLine2Color = -16776961;
        private int mFill2Color = -16776961;

        public Builder(Context context) {
            this.mContext = context;
        }

        public DynamicChartViewController build() {
            ChartView realView = new ChartView(this.mContext);
            realView.setTouchEnabled(false);
            GridLabelRenderer labelRenderer = realView.getGridLabelRenderer();
            LineGraphSeries series = new LineGraphSeries();
            realView.addSeries(series);
            Viewport viewport = realView.getViewport();
            realView.setBackgroundColor(this.mViewBackground);
            labelRenderer.setHorizontalLabelsColor(this.mLabelColor);
            labelRenderer.setVerticalLabelsColor(this.mLabelColor);
            labelRenderer.setHorizontalAxisTitleColor(this.mLabelColor);
            labelRenderer.setVerticalAxisTitleColor(this.mLabelColor);
            realView.setTitleColor(this.mLabelColor);
            labelRenderer.setGridColor(this.mAxisColor);
            series.setColor(this.mLineColor);
            if (!TextUtils.isEmpty((CharSequence)this.mSeriesTitle)) {
                series.setTitle(this.mSeriesTitle);
            }
            LineGraphSeries series2 = null;
            if (!TextUtils.isEmpty((CharSequence)this.mSeries2Title)) {
                series2 = new LineGraphSeries();
                realView.addSeries(series2);
                series2.setTitle(this.mSeries2Title);
                series2.setColor(this.mLine2Color);
            }
            series.setDrawBackground(this.isFill);
            if (this.isFill) {
                series.setBackgroundColor(this.mFillColor);
            }
            if (series2 != null) {
                series2.setDrawBackground(this.isFill);
                if (this.isFill) {
                    series2.setBackgroundColor(this.mFill2Color);
                }
            }
            if (this.mMinX != -1.0 && this.mMaxX != -1.0) {
                viewport.setXAxisBoundsManual(true);
                viewport.setMinX(this.mMinX);
                viewport.setMaxX(this.mMaxX);
            } else {
                viewport.setXAxisBoundsManual(false);
            }
            if (this.mMinY != -1.0 && this.mMaxY != -1.0) {
                viewport.setYAxisBoundsManual(true);
                viewport.setMinY(this.mMinY);
                viewport.setMaxY(this.mMaxY);
            } else {
                viewport.setYAxisBoundsManual(false);
            }
            if (this.mNumXLabels != 0) {
                labelRenderer.setNumHorizontalLabels(this.mNumXLabels);
            }
            if (this.mNumYLabels != 0) {
                labelRenderer.setNumVerticalLabels(this.mNumYLabels);
            }
            if (this.mXAxisTitle != null) {
                labelRenderer.setHorizontalAxisTitle(this.mXAxisTitle);
            }
            if (this.mYAxisTitle != null) {
                labelRenderer.setVerticalAxisTitle(this.mYAxisTitle);
            }
            if (this.mTitle != null) {
                realView.setTitle(this.mTitle);
            }
            if (this.mLabelFormatter != null) {
                labelRenderer.setLabelFormatter(this.mLabelFormatter);
                labelRenderer.setHumanRounding(false);
            }
            viewport.setScalable(false);
            viewport.setScalableY(false);
            viewport.setScrollable(false);
            viewport.setScrollableY(false);
            DynamicChartViewController controller = new DynamicChartViewController(realView);
            if (this.mMaxDataPoints > 0) {
                controller.setMaxPoints(this.mMaxDataPoints);
            }
            return controller;
        }

        public Builder labelFormatter(@Nullable LabelFormatter formatter) {
            this.mLabelFormatter = formatter;
            return this;
        }

        public Builder title(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder lineTitle(@Nullable String title) {
            this.mSeriesTitle = title;
            return this;
        }

        public Builder lineTitle2(@Nullable String title) {
            this.mSeries2Title = title;
            return this;
        }

        public Builder backgroundColor(@ColorInt int background) {
            this.mViewBackground = background;
            return this;
        }

        public Builder fillColor(@ColorInt int fillColor) {
            this.mFillColor = fillColor;
            return this;
        }

        public Builder fillColor2(@ColorInt int fillColor) {
            this.mFill2Color = fillColor;
            return this;
        }

        public Builder labelColor(@ColorInt int labelColor) {
            this.mLabelColor = labelColor;
            return this;
        }

        public Builder axisColor(@ColorInt int axisColor) {
            this.mAxisColor = axisColor;
            return this;
        }

        public Builder lineColor(@ColorInt int lineColor) {
            this.mLineColor = lineColor;
            return this;
        }

        public Builder lineColor2(@ColorInt int line2Color) {
            this.mLine2Color = line2Color;
            return this;
        }

        public Builder isFill(boolean isFill) {
            this.isFill = isFill;
            return this;
        }

        public Builder minX(double minX) {
            this.mMinX = minX;
            return this;
        }

        public Builder maxX(double maxX) {
            this.mMaxX = maxX;
            return this;
        }

        public Builder minY(double minY) {
            this.mMinY = minY;
            return this;
        }

        public Builder maxY(double maxY) {
            this.mMaxY = maxY;
            return this;
        }

        public Builder numXLabels(int numXLabels) {
            this.mNumXLabels = numXLabels;
            return this;
        }

        public Builder numYLabels(int numYLabels) {
            this.mNumYLabels = numYLabels;
            return this;
        }

        public Builder titleOfAxisX(@Nullable String axisXTitle) {
            this.mXAxisTitle = axisXTitle;
            return this;
        }

        public Builder titleOfAxisY(@Nullable String axisYTitle) {
            this.mYAxisTitle = axisYTitle;
            return this;
        }

        public Builder maxDataPoints(int maxDataPoints) {
            this.mMaxDataPoints = maxDataPoints;
            return this;
        }
    }
}

