/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewTreeObserver;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.core.HandlerThreadWrapper;
import com.taobao.weex.analyzer.core.IVDomMonitor;
import com.taobao.weex.analyzer.core.VDomTracker;
import com.taobao.weex.analyzer.pojo.HealthReport;
import com.taobao.weex.utils.WXLogUtils;

public class StandardVDomMonitor
implements IVDomMonitor,
Handler.Callback {
    private HandlerThreadWrapper mHandlerThreadWrapper = new HandlerThreadWrapper("vdom-tracker", this);
    private WXSDKInstance mInstance;
    private LayoutChangeListener mLayoutChangeListener = new LayoutChangeListener();
    private static final int TRACK = 1;
    private static final String TAG = "VDomController";

    @Override
    public void monitor(@NonNull WXSDKInstance instance) {
        this.mInstance = instance;
        View view = instance.getGodCom().getHostView();
        if (view == null) {
            WXLogUtils.e((String)TAG, (String)"host view is null");
            return;
        }
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mLayoutChangeListener);
    }

    @Override
    public void destroy() {
        View hostView;
        if (this.mHandlerThreadWrapper != null) {
            this.mHandlerThreadWrapper.quit();
            this.mHandlerThreadWrapper = null;
        }
        if (this.mInstance != null && this.mLayoutChangeListener != null && (hostView = this.mInstance.getGodCom().getHostView()) != null) {
            if (Build.VERSION.SDK_INT < 16) {
                hostView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mLayoutChangeListener);
            } else {
                hostView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mLayoutChangeListener);
            }
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            try {
                VDomTracker tracker = new VDomTracker((WXSDKInstance)msg.obj);
                HealthReport report = tracker.traverse();
                if (report != null) {
                    report.writeToConsole();
                }
            }
            catch (Exception e) {
                WXLogUtils.e((String)e.getMessage());
            }
            return true;
        }
        return false;
    }

    private class LayoutChangeListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private LayoutChangeListener() {
        }

        public void onGlobalLayout() {
            if (StandardVDomMonitor.this.mInstance == null) {
                WXLogUtils.e((String)"detect layout change but instance is null");
                return;
            }
            WXLogUtils.d((String)StandardVDomMonitor.TAG, (String)("we detect that layout has changed for instance " + StandardVDomMonitor.this.mInstance.getInstanceId()));
            if (StandardVDomMonitor.this.mHandlerThreadWrapper.isAlive()) {
                Message msg = Message.obtain();
                msg.what = 1;
                msg.obj = StandardVDomMonitor.this.mInstance;
                StandardVDomMonitor.this.mHandlerThreadWrapper.getHandler().sendMessage(msg);
            }
        }
    }
}

