/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.support.annotation.Nullable;

public class ShakeDetector
implements SensorEventListener {
    private static final int MAX_SAMPLES = 25;
    private static final int MIN_TIME_BETWEEN_SAMPLES_MS = 20;
    private static final int VISIBLE_TIME_RANGE_MS = 500;
    private static final int MAGNITUDE_THRESHOLD = 25;
    private static final int PERCENT_OVER_THRESHOLD_FOR_SHAKE = 66;
    private ShakeListener mShakeListener;
    @Nullable
    private SensorManager mSensorManager;
    private long mLastTimestamp;
    private int mCurrentIndex;
    @Nullable
    private double[] mMagnitudes;
    @Nullable
    private long[] mTimestamps;

    public ShakeDetector(@Nullable ShakeListener listener) {
        this.mShakeListener = listener;
    }

    public void start(@Nullable SensorManager manager) {
        if (manager == null) {
            return;
        }
        Sensor accelerometer = manager.getDefaultSensor(1);
        if (accelerometer != null) {
            this.mSensorManager = manager;
            this.mLastTimestamp = -1L;
            this.mCurrentIndex = 0;
            this.mMagnitudes = new double[25];
            this.mTimestamps = new long[25];
            this.mSensorManager.registerListener((SensorEventListener)this, accelerometer, 2);
        }
    }

    public void stop() {
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            this.mSensorManager = null;
        }
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.mTimestamps == null || this.mMagnitudes == null) {
            return;
        }
        if (event.timestamp - this.mLastTimestamp < 20L) {
            return;
        }
        float ax = event.values[0];
        float ay = event.values[1];
        float az = event.values[2];
        this.mLastTimestamp = event.timestamp;
        this.mTimestamps[this.mCurrentIndex] = event.timestamp;
        this.mMagnitudes[this.mCurrentIndex] = Math.sqrt(ax * ax + ay * ay + az * az);
        this.maybeDispatchShake(event.timestamp);
        this.mCurrentIndex = (this.mCurrentIndex + 1) % 25;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void maybeDispatchShake(long currentTimestamp) {
        if (this.mTimestamps == null || this.mMagnitudes == null) {
            return;
        }
        int numOverThreshold = 0;
        int total = 0;
        for (int i = 0; i < 25; ++i) {
            int index = (this.mCurrentIndex - i + 25) % 25;
            if (currentTimestamp - this.mTimestamps[index] >= 500L) continue;
            ++total;
            if (!(this.mMagnitudes[index] >= 25.0)) continue;
            ++numOverThreshold;
        }
        if ((double)numOverThreshold / (double)total > 0.66 && this.mShakeListener != null) {
            this.mShakeListener.onShake();
        }
    }

    public static interface ShakeListener {
        public void onShake();
    }
}

