/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.support.annotation.Nullable;
import com.taobao.weex.analyzer.core.LogcatDumper;
import java.util.LinkedList;
import java.util.List;

public class LogcatDumpBuilder {
    private LogcatDumper.OnLogReceivedListener logReceivedListener;
    private List<LogcatDumper.Rule> ruleList;
    private int level = 0;
    private boolean isCacheEnabled;
    private int cacheLimit;

    public LogcatDumpBuilder listener(LogcatDumper.OnLogReceivedListener listener) {
        this.logReceivedListener = listener;
        return this;
    }

    public LogcatDumpBuilder rule(@Nullable LogcatDumper.Rule rule) {
        if (rule == null) {
            return this;
        }
        if (this.ruleList == null) {
            this.ruleList = new LinkedList<LogcatDumper.Rule>();
        }
        this.ruleList.add(rule);
        return this;
    }

    public LogcatDumpBuilder level(int level) {
        this.level = level;
        return this;
    }

    public LogcatDumpBuilder enableCache(boolean enabled) {
        this.isCacheEnabled = enabled;
        return this;
    }

    public LogcatDumpBuilder cacheLimit(int limit) {
        this.cacheLimit = limit;
        return this;
    }

    public LogcatDumper build() {
        LogcatDumper dumper = new LogcatDumper(this.logReceivedListener);
        dumper.setLevel(this.level);
        dumper.setCacheLimit(this.cacheLimit);
        dumper.setCacheEnabled(this.isCacheEnabled);
        if (this.ruleList != null) {
            for (LogcatDumper.Rule rule : this.ruleList) {
                dumper.addRule(rule);
            }
        }
        return dumper;
    }
}

