/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.SensorManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Toast;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.IWXDevOptions;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.DevOptionsConfig;
import com.taobao.weex.analyzer.core.FPSSampler;
import com.taobao.weex.analyzer.core.JSExceptionCatcher;
import com.taobao.weex.analyzer.core.Performance;
import com.taobao.weex.analyzer.core.RemoteDebugManager;
import com.taobao.weex.analyzer.core.ShakeDetector;
import com.taobao.weex.analyzer.core.VDomController;
import com.taobao.weex.analyzer.core.WXPerfStorage;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.view.CpuSampleView;
import com.taobao.weex.analyzer.view.DevOption;
import com.taobao.weex.analyzer.view.EntranceView;
import com.taobao.weex.analyzer.view.FpsSampleView;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.LogView;
import com.taobao.weex.analyzer.view.MemorySampleView;
import com.taobao.weex.analyzer.view.PerfSampleOverlayView;
import com.taobao.weex.analyzer.view.ScalpelFrameLayout;
import com.taobao.weex.analyzer.view.ScalpelViewController;
import com.taobao.weex.analyzer.view.SettingsActivity;
import com.taobao.weex.analyzer.view.StorageView;
import com.taobao.weex.analyzer.view.TrafficSampleView;
import com.taobao.weex.analyzer.view.VDomDepthSampleView;
import com.taobao.weex.analyzer.view.WXPerformanceAnalysisView;
import java.util.ArrayList;
import java.util.List;

public class WeexDevOptions
implements IWXDevOptions {
    private Context mContext;
    private ShakeDetector mShakeDetector;
    private DevOptionsConfig mConfig;
    private LogView mLogView;
    private MemorySampleView mMemorySampleView;
    private CpuSampleView mCpuSampleView;
    private FpsSampleView mFpsSampleView;
    private TrafficSampleView mTrafficSampleView;
    private String mCurPageName;
    private ScalpelViewController mScalpelViewController;
    private PerfSampleOverlayView mPerfMonitorOverlayView;
    private VDomDepthSampleView mVDomDepthSampleView;
    private boolean shown = false;
    private List<DevOption> mExtraOptions = null;
    private VDomController mVdomController;
    private WXSDKInstance mInstance;

    public WeexDevOptions(@NonNull Context context) {
        this.mContext = context;
        this.mConfig = new DevOptionsConfig(context);
        this.mPerfMonitorOverlayView = new PerfSampleOverlayView(context);
        this.mVDomDepthSampleView = new VDomDepthSampleView(context);
        this.mLogView = new LogView(context);
        this.mLogView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setLogOutputEnabled(false);
                }
            }
        });
        this.mLogView.setOnLogConfigChangedListener(new LogView.OnLogConfigChangedListener(){

            @Override
            public void onLogLevelChanged(int level) {
                WeexDevOptions.this.mConfig.setLogLevel(level);
            }

            @Override
            public void onLogFilterChanged(String filterName) {
                WeexDevOptions.this.mConfig.setLogFilter(filterName);
            }

            @Override
            public void onLogSizeChanged(int size) {
                WeexDevOptions.this.mConfig.setLogViewSize(size);
            }
        });
        this.mMemorySampleView = new MemorySampleView(context);
        this.mMemorySampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setMemoryChartEnabled(false);
                }
            }
        });
        this.mCpuSampleView = new CpuSampleView(context);
        this.mCpuSampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setCpuChartEnabled(false);
                }
            }
        });
        this.mTrafficSampleView = new TrafficSampleView(context);
        this.mTrafficSampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setTrafficChartEnabled(false);
                }
            }
        });
        this.mFpsSampleView = new FpsSampleView(context);
        this.mFpsSampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setFpsChartEnabled(false);
                }
            }
        });
        this.mShakeDetector = new ShakeDetector(new ShakeDetector.ShakeListener(){

            @Override
            public void onShake() {
                WeexDevOptions.this.showDevOptions();
            }
        });
        this.mVdomController = new VDomController();
    }

    private List<DevOption> registerDefaultOptions() {
        ArrayList<DevOption> options = new ArrayList<DevOption>();
        options.add(new DevOption("weex\u6027\u80fd\u6307\u6807", R.drawable.wxt_icon_performance, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mCurPageName == null) {
                    Toast.makeText((Context)WeexDevOptions.this.mContext, (CharSequence)"internal error", (int)0).show();
                    return;
                }
                Performance performance = WXPerfStorage.getInstance().getLatestPerformance(WeexDevOptions.this.mCurPageName);
                List<Performance> list = WXPerfStorage.getInstance().getPerformanceList(WeexDevOptions.this.mCurPageName);
                if (performance == null) {
                    return;
                }
                WXPerformanceAnalysisView view = new WXPerformanceAnalysisView(WeexDevOptions.this.mContext, performance, list);
                view.show();
            }
        }));
        options.add(new DevOption("weex storage", R.drawable.wxt_icon_storage, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                StorageView mStorageView = new StorageView(WeexDevOptions.this.mContext);
                mStorageView.show();
            }
        }));
        options.add(new DevOption("3d\u89c6\u56fe", R.drawable.wxt_icon_3d_rotation, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mScalpelViewController != null) {
                    WeexDevOptions.this.mScalpelViewController.toggleScalpelEnabled();
                }
            }
        }, true));
        options.add(new DevOption("\u65e5\u5fd7", R.drawable.wxt_icon_log, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isLogOutputEnabled()) {
                    WeexDevOptions.this.mConfig.setLogOutputEnabled(false);
                    WeexDevOptions.this.mLogView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setLogOutputEnabled(true);
                    WeexDevOptions.this.mLogView.setLogLevel(WeexDevOptions.this.mConfig.getLogLevel());
                    WeexDevOptions.this.mLogView.setFilterName(WeexDevOptions.this.mConfig.getLogFilter());
                    WeexDevOptions.this.mLogView.setViewSize(WeexDevOptions.this.mConfig.getLogViewSize());
                    WeexDevOptions.this.mLogView.show();
                }
            }
        }, true));
        options.add(new DevOption("\u5185\u5b58", R.drawable.wxt_icon_memory, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isMemoryChartEnabled()) {
                    WeexDevOptions.this.mConfig.setMemoryChartEnabled(false);
                    WeexDevOptions.this.mMemorySampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setMemoryChartEnabled(true);
                    WeexDevOptions.this.mMemorySampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("CPU", R.drawable.wxt_icon_cpu, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isCPUChartEnabled()) {
                    WeexDevOptions.this.mConfig.setCpuChartEnabled(false);
                    WeexDevOptions.this.mCpuSampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setCpuChartEnabled(true);
                    WeexDevOptions.this.mCpuSampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("fps", R.drawable.wxt_icon_fps, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (!FPSSampler.isSupported()) {
                    Toast.makeText((Context)WeexDevOptions.this.mContext, (CharSequence)"your device is not support.", (int)0).show();
                    return;
                }
                if (WeexDevOptions.this.mConfig.isFpsChartEnabled()) {
                    WeexDevOptions.this.mConfig.setFpsChartEnabled(false);
                    WeexDevOptions.this.mFpsSampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setFpsChartEnabled(true);
                    WeexDevOptions.this.mFpsSampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("\u6d41\u91cf", R.drawable.wxt_icon_traffic, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isTrafficChartEnabled()) {
                    WeexDevOptions.this.mConfig.setTrafficChartEnabled(false);
                    WeexDevOptions.this.mTrafficSampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setTrafficChartEnabled(true);
                    WeexDevOptions.this.mTrafficSampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("\u7efc\u5408\u6027\u80fd", R.drawable.wxt_icon_multi_performance, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isPerfCommonEnabled()) {
                    WeexDevOptions.this.mConfig.setPerfCommonEnabled(false);
                    WeexDevOptions.this.mPerfMonitorOverlayView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setPerfCommonEnabled(true);
                    WeexDevOptions.this.mPerfMonitorOverlayView.show();
                }
            }
        }, true));
        options.add(new DevOption("vDom\u5c42\u7ea7", R.drawable.wxt_icon_vdom_depth, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isVDomDepthEnabled()) {
                    WeexDevOptions.this.mConfig.setVdomDepthEnabled(false);
                    WeexDevOptions.this.mVDomDepthSampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setVdomDepthEnabled(true);
                    WeexDevOptions.this.mVDomDepthSampleView.show();
                    WeexDevOptions.this.mVDomDepthSampleView.bindInstance(WeexDevOptions.this.mInstance);
                }
            }
        }, true));
        options.add(new DevOption("js\u8fdc\u7a0b\u8c03\u8bd5", R.drawable.wxt_icon_debug, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                RemoteDebugManager.getInstance().toggle(WeexDevOptions.this.mContext);
            }
        }));
        options.add(new DevOption("\u914d\u7f6e", R.drawable.wxt_icon_settings, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                SettingsActivity.launch(WeexDevOptions.this.mContext);
            }
        }));
        return options;
    }

    private void showDevOptions() {
        if (this.shown) {
            return;
        }
        if (this.mContext == null) {
            return;
        }
        if (this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing()) {
            return;
        }
        EntranceView.Creator creator = new EntranceView.Creator(this.mContext).injectOptions(this.registerDefaultOptions());
        if (this.mExtraOptions != null && !this.mExtraOptions.isEmpty()) {
            creator.injectOptions(this.mExtraOptions);
        }
        EntranceView e = creator.create();
        e.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                WeexDevOptions.this.shown = false;
            }
        });
        e.show();
        this.shown = true;
    }

    public void registerExtraOption(@NonNull DevOption option) {
        if (this.mExtraOptions == null) {
            this.mExtraOptions = new ArrayList<DevOption>();
        }
        this.mExtraOptions.add(option);
    }

    public void registerExtraOption(@NonNull String optionName, int iconRes, final @NonNull Runnable runnable) {
        DevOption option = new DevOption();
        option.listener = new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    Log.e((String)"weex-analyzer", (String)e.getMessage());
                }
            }
        };
        option.iconRes = iconRes;
        option.optionName = optionName;
        this.registerExtraOption(option);
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        this.mShakeDetector.start((SensorManager)this.mContext.getSystemService("sensor"));
        if (this.mConfig.isPerfCommonEnabled()) {
            this.mPerfMonitorOverlayView.show();
        } else {
            this.mPerfMonitorOverlayView.dismiss();
        }
        if (this.mConfig.isVDomDepthEnabled()) {
            this.mVDomDepthSampleView.show();
            this.mVDomDepthSampleView.bindInstance(this.mInstance);
        } else {
            this.mVDomDepthSampleView.dismiss();
        }
        if (this.mConfig.isLogOutputEnabled()) {
            this.mLogView.setLogLevel(this.mConfig.getLogLevel());
            this.mLogView.setFilterName(this.mConfig.getLogFilter());
            this.mLogView.setViewSize(this.mConfig.getLogViewSize());
            this.mLogView.show();
        } else {
            this.mLogView.dismiss();
        }
        if (this.mConfig.isMemoryChartEnabled()) {
            this.mMemorySampleView.show();
        } else {
            this.mMemorySampleView.dismiss();
        }
        if (this.mConfig.isCPUChartEnabled()) {
            this.mCpuSampleView.show();
        } else {
            this.mCpuSampleView.dismiss();
        }
        if (this.mConfig.isFpsChartEnabled()) {
            this.mFpsSampleView.show();
        } else {
            this.mFpsSampleView.dismiss();
        }
        if (this.mConfig.isTrafficChartEnabled()) {
            this.mTrafficSampleView.show();
        } else {
            this.mTrafficSampleView.dismiss();
        }
        if (this.mScalpelViewController != null) {
            this.mScalpelViewController.resume();
        }
    }

    @Override
    public void onPause() {
        this.mShakeDetector.stop();
        if (this.mConfig.isPerfCommonEnabled()) {
            this.mPerfMonitorOverlayView.dismiss();
        }
        if (this.mConfig.isVDomDepthEnabled()) {
            this.mVDomDepthSampleView.dismiss();
        }
        if (this.mConfig.isLogOutputEnabled()) {
            this.mLogView.dismiss();
        }
        if (this.mConfig.isMemoryChartEnabled()) {
            this.mMemorySampleView.dismiss();
        }
        if (this.mConfig.isFpsChartEnabled()) {
            this.mFpsSampleView.dismiss();
        }
        if (this.mConfig.isCPUChartEnabled()) {
            this.mCpuSampleView.dismiss();
        }
        if (this.mConfig.isTrafficChartEnabled()) {
            this.mTrafficSampleView.dismiss();
        }
        if (this.mScalpelViewController != null) {
            this.mScalpelViewController.pause();
        }
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
        if (this.mVdomController != null) {
            this.mVdomController.destroy();
            this.mVdomController = null;
        }
    }

    @Override
    public void onWeexRenderSuccess(@Nullable WXSDKInstance instance) {
        if (instance == null) {
            return;
        }
        this.mInstance = instance;
        this.mCurPageName = WXPerfStorage.getInstance().savePerformance(instance);
        if (this.mVdomController != null) {
            this.mVdomController.monitor(instance);
        }
        if (this.mVDomDepthSampleView != null) {
            this.mVDomDepthSampleView.bindInstance(instance);
        }
    }

    @Override
    public View onWeexViewCreated(WXSDKInstance instance, View view) {
        if (instance == null || view == null || view.getContext() == null) {
            return null;
        }
        if (view.getParent() != null) {
            return view;
        }
        this.mScalpelViewController = new ScalpelViewController(this.mContext);
        this.mScalpelViewController.setOnToggleListener(new ScalpelViewController.OnToggleListener(){

            @Override
            public void onToggle(View view, boolean isScalpelEnabled) {
                Toast.makeText((Context)WeexDevOptions.this.mContext, (CharSequence)("3d layer is " + (isScalpelEnabled ? "enabled" : "disabled")), (int)0).show();
            }
        });
        this.mScalpelViewController.setOnDrawViewNameListener(new ScalpelFrameLayout.OnDrawViewNameListener(){

            @Override
            @Nullable
            public String onDrawViewName(@NonNull View view, @NonNull String rawClazzName) {
                for (String name : DevOptionsConfig.WHITE_SCALPEL_VIEW_NAMES) {
                    if (!rawClazzName.equalsIgnoreCase(name)) continue;
                    return rawClazzName;
                }
                return null;
            }
        });
        return this.mScalpelViewController.wrapView(view);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!SDKUtils.isEmulator()) {
            return false;
        }
        if (keyCode == 82) {
            this.showDevOptions();
            return true;
        }
        return false;
    }

    @Override
    public void onException(WXSDKInstance instance, String errCode, String msg) {
        if (this.mConfig != null && this.mConfig.isShownJSException()) {
            try {
                JSExceptionCatcher.catchException(this.mContext, instance, errCode, msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

