/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.useage;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.talent.compat.web.core.callback.WebClient;
import com.talent.compat.web.core.useage.EasyWebView;
import com.talent.compat.web.core.useage.ThemeWebIndicator;
import com.talent.compat.web.core.useage.WebIndicator;

public class WebViewContainer
extends FrameLayout
implements WebClient {
    private static final String DEFAULT_ERROR_PAGE = "file:///android_asset/error.html";
    private final EasyWebView mWebView;
    private TitleGetter mTitleGetter;
    private WebIndicator mWebIndicator;
    private View mErrorView;
    private boolean mErrorHappened = false;
    private String mLastUrl;

    public WebViewContainer(@NonNull Context context) {
        this(context, null, 0);
    }

    public WebViewContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WebViewContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mWebView = new EasyWebView(context);
        this.mWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mWebView.asDefault();
        this.mWebView.registerWebClient(this);
        this.mWebView.prepare();
        this.addView((View)this.mWebView);
        this.mWebIndicator = new ThemeWebIndicator(context);
        this.mWebIndicator.reset();
        this.addView((View)this.mWebIndicator);
    }

    public EasyWebView getWebView() {
        return this.mWebView;
    }

    public WebSettings getSettings() {
        return this.mWebView.as();
    }

    public void atTitleGotten(TitleGetter titleGetter) {
        this.mTitleGetter = titleGetter;
    }

    public void setErrorPage(@LayoutRes int layout, @IdRes int actionId) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(layout, (ViewGroup)this, false);
        if (view != null) {
            View actionView = view.findViewById(actionId);
            if (actionView != null) {
                actionView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        WebViewContainer.this.mWebView.reload();
                    }
                });
            }
            view.setVisibility(8);
            this.addView(view);
            this.mErrorView = view;
        }
    }

    @Deprecated
    public void setWebIndicator(WebIndicator indicator) {
        if (indicator == null) {
            return;
        }
        if (!(indicator instanceof View)) {
            return;
        }
        View view = (View)indicator;
        int index = this.indexOfChild((View)this.mWebIndicator);
        this.removeViewAt(index);
        this.addView(view, index);
        this.mWebIndicator = indicator;
    }

    public void setIndicatorColor(int color) {
        if (this.mWebIndicator != null && this.mWebIndicator instanceof ThemeWebIndicator) {
            ((ThemeWebIndicator)this.mWebIndicator).setColor(color);
        }
    }

    @Override
    public void onReceivedTitle(WebView view, String title) {
        if (this.mTitleGetter != null) {
            this.mTitleGetter.onGetTitle(view, title);
        }
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (!DEFAULT_ERROR_PAGE.equals(url)) {
            this.mLastUrl = url;
        }
        this.mErrorHappened = false;
        if (this.mWebIndicator != null) {
            this.mWebIndicator.show();
        }
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        if (this.mWebIndicator != null) {
            this.mWebIndicator.setProgress(newProgress);
        }
    }

    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.mErrorHappened = true;
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        if (this.mWebIndicator != null) {
            this.mWebIndicator.setProgress(100);
            this.mWebIndicator.hide();
        }
        if (this.mErrorHappened) {
            this.loadErrorPage();
        } else {
            this.mWebView.setVisibility(0);
            if (this.mErrorView != null) {
                this.mErrorView.setVisibility(8);
            }
        }
    }

    public void load(String url) {
        if (this.mWebView != null) {
            this.mWebView.loadUrl(url);
        }
    }

    public void loadErrorPage() {
        if (this.mErrorView != null) {
            this.mErrorView.setVisibility(0);
            this.mWebView.setVisibility(8);
        } else {
            this.mWebView.setVisibility(0);
            this.mWebView.loadUrl(DEFAULT_ERROR_PAGE);
        }
    }

    public boolean goBack() {
        if (this.mWebView == null) {
            return false;
        }
        if (this.indexOfChild((View)this.mWebView) < 0) {
            return false;
        }
        if (this.mWebView.canGoBack()) {
            if (DEFAULT_ERROR_PAGE.equals(this.mWebView.getUrl())) {
                this.mWebView.goBackOrForward(-2);
                return true;
            }
            this.mWebView.goBack();
            return true;
        }
        return false;
    }

    public String getUrl() {
        if (this.mWebView == null) {
            return null;
        }
        String url = this.mWebView.getUrl();
        if (DEFAULT_ERROR_PAGE.equals(url)) {
            return this.mLastUrl;
        }
        return url;
    }

    public static interface TitleGetter {
        public void onGetTitle(WebView var1, String var2);
    }
}

