/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.js;

import android.webkit.JsPromptResult;
import android.webkit.WebView;
import com.talent.compat.web.core.js.JsCallJava;
import com.talent.compat.web.core.js.JsConstructors;
import com.talent.compat.web.core.js.JsInjection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class UnderSupportJsInjection
implements JsInjection {
    private Map<String, JsCallJava> mJsCallJavas;

    @Override
    public void addJavascriptInterface(WebView webView, Object interfaceObj, String interfaceName) {
        if (this.mJsCallJavas == null) {
            this.mJsCallJavas = new HashMap<String, JsCallJava>();
        }
        this.mJsCallJavas.put(interfaceName, JsCallJava.newCall(interfaceObj, interfaceName));
        this.injectJavaScript(webView);
    }

    @Override
    public void injectJavaScript(WebView webView) {
        if (this.mJsCallJavas != null) {
            for (Map.Entry<String, JsCallJava> entry : this.mJsCallJavas.entrySet()) {
                webView.loadUrl(JsConstructors.buildNotRepeatInjectJS(entry.getKey(), entry.getValue().getPreloadInterfaceJs()));
            }
        }
    }

    @Override
    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        if (this.mJsCallJavas != null && JsCallJava.isSafeWebViewCallMsg(message)) {
            JsCallJava mJsCallJava;
            JSONObject jsonObject = JsCallJava.getMsgJSONObject(message);
            String interfacedName = JsCallJava.getInterfacedName(jsonObject);
            if (interfacedName != null && (mJsCallJava = this.mJsCallJavas.get(interfacedName)) != null) {
                result.confirm(mJsCallJava.call(view, jsonObject));
            }
            return true;
        }
        return false;
    }

    @Override
    public void unregister() {
        if (this.mJsCallJavas != null) {
            this.mJsCallJavas.clear();
            this.mJsCallJavas = null;
        }
    }
}

