/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.js;

import android.webkit.WebView;
import java.lang.ref.WeakReference;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsCallback {
    private static final String CALLBACK_JS_FORMAT = "javascript:%s.callback(%d, %d %s);";
    private int mIndex;
    private boolean mCouldGoOn = true;
    private WeakReference<WebView> mWebViewRef;
    private int mIsPermanent;
    private String mInjectedName;

    public JsCallback(WebView view, String injectedName, int index) {
        this.mWebViewRef = new WeakReference<WebView>(view);
        this.mInjectedName = injectedName;
        this.mIndex = index;
    }

    public void apply(Object ... args) throws JsCallbackException {
        if (this.mWebViewRef.get() == null) {
            throw new JsCallbackException("the WebView related to the JsCallback has been recycled");
        }
        if (!this.mCouldGoOn) {
            throw new JsCallbackException("the JsCallback isn't permanent,cannot be called more than once");
        }
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(",");
            boolean isStrArg = arg instanceof String;
            boolean isObjArg = this.isJavaScriptObject(arg);
            if (isStrArg && !isObjArg) {
                sb.append("\"");
            }
            sb.append(String.valueOf(arg));
            if (!isStrArg || isObjArg) continue;
            sb.append("\"");
        }
        String execJs = String.format(Locale.getDefault(), CALLBACK_JS_FORMAT, this.mInjectedName, this.mIndex, this.mIsPermanent, sb.toString());
        ((WebView)this.mWebViewRef.get()).loadUrl(execJs);
        this.mCouldGoOn = this.mIsPermanent > 0;
    }

    private boolean isJavaScriptObject(Object obj) {
        if (obj instanceof JSONObject || obj instanceof JSONArray) {
            return true;
        }
        String json = obj.toString();
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            try {
                new JSONArray(json);
            }
            catch (JSONException e1) {
                return false;
            }
        }
        return true;
    }

    public void setPermanent(boolean value) {
        this.mIsPermanent = value ? 1 : 0;
    }

    public static class JsCallbackException
    extends Exception {
        public JsCallbackException(String msg) {
            super(msg);
        }
    }
}

