/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.compat;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebView;
import java.lang.reflect.Method;

public final class WebViewCompat {
    public static boolean removeSearchBoxJavaBridge(WebView webView) {
        try {
            if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 17) {
                Method method = webView.getClass().getMethod("removeJavascriptInterface", String.class);
                method.invoke((Object)webView, "searchBoxJavaBridge_");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void detachWebParent(WebView webView) {
        ViewParent parent = webView.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            ViewGroup mWebViewContainer = (ViewGroup)parent;
            mWebViewContainer.removeAllViewsInLayout();
        }
    }

    public static Pair<Boolean, String> isWebViewPackageException(Throwable e) {
        String messageCause = e.getCause() == null ? e.toString() : e.getCause().toString();
        String trace = Log.getStackTraceString((Throwable)e);
        if (trace.contains("android.content.pm.PackageManager$NameNotFoundException") || trace.contains("java.lang.RuntimeException: Cannot load WebView") || trace.contains("android.webkit.WebViewFactory$MissingWebViewPackageException: Failed to load WebView provider: No WebView installed")) {
            return new Pair((Object)true, (Object)("WebView load failed, " + messageCause));
        }
        return new Pair((Object)false, (Object)messageCause);
    }

    public static boolean isOverrideMethod(Object currentObject, String methodName, String method, Class ... clazzs) {
        boolean tag = false;
        if (currentObject == null) {
            return false;
        }
        try {
            Class<?> clazz = currentObject.getClass();
            Method mMethod = clazz.getMethod(methodName, clazzs);
            String gStr = mMethod.toGenericString();
            tag = !gStr.contains(method);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tag;
    }

    public static String getApplicationName(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        String applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
        return applicationName;
    }
}

