/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core;

import android.graphics.Bitmap;
import android.support.annotation.RequiresApi;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import com.talent.compat.web.core.CompatWebView;
import com.talent.compat.web.core.WebViewClientBase;
import com.talent.compat.web.core.compat.AccessibilityCompat;

public class WebViewClientWrapper
extends WebViewClientBase {
    private final CompatWebView mWebView;
    private final AccessibilityCompat mAccessCompat;

    public WebViewClientWrapper(CompatWebView mWebView, AccessibilityCompat mAccessCompat) {
        super(null);
        this.mWebView = mWebView;
        this.mAccessCompat = mAccessCompat;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.mWebView.getJsInjection().injectJavaScript(view);
        this.mWebView.injectJavaScript();
        this.mWebView.onPageStarted(view, url, favicon);
        this.mAccessCompat.fixedAccessibilityInjectorExceptionForOnPageFinished(url);
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.mWebView.onPageFinished(view, url);
    }

    @Override
    @RequiresApi(api=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        if (request.isForMainFrame()) {
            this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }
    }

    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        this.mWebView.onReceivedError(view, errorCode, description, failingUrl);
    }
}

