package com.talent.compat.web.core.js;

import android.webkit.JsPromptResult;
import android.webkit.WebView;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by wbs on 2018/3/20 0020.
 */

public class UnderSupportJsInjection implements JsInjection {
    private Map<String, JsCallJava> mJsCallJavas;
    @Override
    public void addJavascriptInterface(WebView webView, Object interfaceObj, String interfaceName) {
        if (mJsCallJavas == null) {
            mJsCallJavas = new HashMap<>();
        }
        mJsCallJavas.put(interfaceName, JsCallJava.newCall(interfaceObj, interfaceName));
        injectJavaScript(webView);
    }

    @Override
    public void injectJavaScript(WebView webView) {
        if(mJsCallJavas!=null) {
            for (Map.Entry<String, JsCallJava> entry : mJsCallJavas.entrySet()) {
                webView.loadUrl(JsConstructors.buildNotRepeatInjectJS(entry.getKey(), entry.getValue().getPreloadInterfaceJs()));
            }
        }
    }

    @Override
    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        if (mJsCallJavas != null && JsCallJava.isSafeWebViewCallMsg(message)) {
            JSONObject jsonObject = JsCallJava.getMsgJSONObject(message);
            String interfacedName = JsCallJava.getInterfacedName(jsonObject);
            if (interfacedName != null) {
                JsCallJava mJsCallJava = mJsCallJavas.get(interfacedName);
                if (mJsCallJava != null) {
                    result.confirm(mJsCallJava.call(view, jsonObject));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void unregister() {
        if(mJsCallJavas!=null){
            mJsCallJavas.clear();
            mJsCallJavas = null;
        }
    }


}
