package com.talent.compat.web.core.compat;

import android.annotation.SuppressLint;
import android.webkit.WebView;

import java.lang.reflect.Field;

/**
 * Created by wbs on 2018/3/20 0020.
 */

public class WebViewConfigCompat {

    public interface WebViewConfigHandler {

        void destroyWebViewConfigCallback();
    }

    public static class LowVersionHandler implements WebViewConfigHandler {

        @Override
        public void destroyWebViewConfigCallback() {
            try {
                Field field = WebView.class.getDeclaredField("mWebViewCore");
                field = field.getType().getDeclaredField("mBrowserFrame");
                field = field.getType().getDeclaredField("sConfigCallback");
                field.setAccessible(true);
                field.set(null, null);
            } catch (NoSuchFieldException ignored) {

            } catch (IllegalAccessException ignored) {

            }
        }
    }

    public static class JellyBeanHandler implements WebViewConfigHandler {

        @Override
        public void destroyWebViewConfigCallback() {
            try {
                @SuppressLint("PrivateApi") Field sConfigCallback = Class.forName("android.webkit.BrowserFrame").getDeclaredField("sConfigCallback");
                if (sConfigCallback != null) {
                    sConfigCallback.setAccessible(true);
                    sConfigCallback.set(null, null);
                }
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static class KitKatHandler implements WebViewConfigHandler {

        @Override
        public void destroyWebViewConfigCallback() {
            //do nothing
        }
    }
}
