package com.talent.compat.web.core;

import android.util.Log;
import android.webkit.JsPromptResult;
import android.webkit.WebView;

/**
 * Created by wbs on 2018/3/20 0020.
 */

public class WebChromeClientWrapper extends WebChromeClientBase {

    private final CompatWebView mWebView;


    public WebChromeClientWrapper(CompatWebView webView){
        this.mWebView = webView;
    }

    @Override
    public void onReceivedTitle(WebView view, String title) {
        Log.e("WebChromeClientWrapper","title = "+title);
        mWebView.onReceivedTitle(view,title);
        super.onReceivedTitle(view, title);
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        mWebView.getJsInjection().injectJavaScript(mWebView);
        mWebView.injectJavaScript();
        mWebView.onProgressChanged(view,newProgress);
        super.onProgressChanged(view, newProgress);
    }

    @Override
    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        boolean flag = mWebView.getJsInjection().onJsPrompt(view,url,message,defaultValue,result);
        super.onJsPrompt(view,url,message,defaultValue,result);
        return flag;

    }
}
