/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.useage;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.talent.compat.web.R;
import com.talent.compat.web.core.compat.WebViewCompat;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultWebViewClient
extends WebViewClient {
    public static final String INTENT_SCHEME = "intent";
    public static final String ALIPAYS_SCHEME = "alipays";
    public static final String SCHEME_SMS = "sms";
    public static final String WE_CHAT_PAY_SCHEME = "weixin://wap/pay?";
    private static final Set<String> _SCHEMA_LIST = new HashSet<String>();
    private static final int CONSTANTS_ABNORMAL_BIG = 7;
    private boolean mAutoDealLink = true;
    private boolean mIsInterceptUnknownUrl = true;
    private int mLinkPageOpenMode;
    private final WeakReference<Activity> mWeakReference;

    public DefaultWebViewClient(Builder builder) {
        this.mWeakReference = new WeakReference<Activity>(builder.mActivity);
        this.mAutoDealLink = builder.mWebClientHelper;
        this.mIsInterceptUnknownUrl = builder.mIsInterceptUnknownScheme;
        this.mLinkPageOpenMode = builder.mLinkPageOpenMode;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        boolean parentIntercept = super.shouldOverrideUrlLoading(view, request);
        return this.shouldOverrideUrl(view, request.getUrl().toString(), parentIntercept);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        boolean parentIntercept = super.shouldOverrideUrlLoading(view, url);
        return this.shouldOverrideUrl(view, url, parentIntercept);
    }

    private boolean shouldOverrideUrl(WebView view, String url, boolean parentIntercept) {
        if (parentIntercept) {
            return true;
        }
        try {
            Uri uri = Uri.parse((String)url);
            String schema = uri.getScheme();
            if (!_SCHEMA_LIST.contains(schema)) {
                return this.handleUnknownUrl(url);
            }
            if (!this.mAutoDealLink) {
                return false;
            }
            if (this.handleCommonLink(url)) {
                return true;
            }
            if (url.startsWith(INTENT_SCHEME)) {
                this.handleIntentUrl(url);
                return true;
            }
            if (url.startsWith(WE_CHAT_PAY_SCHEME)) {
                this.startActivity(url);
                return true;
            }
            if (url.startsWith(ALIPAYS_SCHEME) && this.lookup(url)) {
                return true;
            }
        }
        catch (Exception e) {
            return this.handleUnknownUrl(url);
        }
        return false;
    }

    private boolean handleUnknownUrl(String url) {
        return this.mIsInterceptUnknownUrl && this.queryActivitiesNumber(url) > 0 && this.urlOpenWays(url);
    }

    private boolean handleCommonLink(String url) {
        if (url.startsWith("tel:") || url.startsWith(SCHEME_SMS) || url.startsWith("mailto:") || url.startsWith("geo:0,0?q=")) {
            try {
                Activity mActivity = null;
                mActivity = (Activity)this.mWeakReference.get();
                if (mActivity == null) {
                    return false;
                }
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                mActivity.startActivity(intent);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void handleIntentUrl(String intentUrl) {
        try {
            if (TextUtils.isEmpty((CharSequence)intentUrl) || !intentUrl.startsWith(INTENT_SCHEME)) {
                return;
            }
            this.lookup(intentUrl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean lookup(String url) {
        try {
            Intent intent;
            Activity mActivity = null;
            mActivity = (Activity)this.mWeakReference.get();
            if (mActivity == null) {
                return true;
            }
            PackageManager packageManager = mActivity.getPackageManager();
            ResolveInfo info = packageManager.resolveActivity(intent = Intent.parseUri((String)url, (int)1), 65536);
            if (info != null) {
                mActivity.startActivity(intent);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private void startActivity(String url) {
        try {
            if (this.mWeakReference.get() == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            ((Activity)this.mWeakReference.get()).startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int queryActivitiesNumber(String url) {
        try {
            if (this.mWeakReference.get() == null) {
                return 0;
            }
            Intent intent = Intent.parseUri((String)url, (int)1);
            PackageManager mPackageManager = ((Activity)this.mWeakReference.get()).getPackageManager();
            List mResolveInfos = mPackageManager.queryIntentActivities(intent, 65536);
            return mResolveInfos == null ? 0 : mResolveInfos.size();
        }
        catch (URISyntaxException ignore) {
            return 0;
        }
    }

    private boolean urlOpenWays(final String url) {
        switch (this.mLinkPageOpenMode) {
            case 0: {
                this.lookup(url);
                return true;
            }
            case 1: {
                Context context = (Context)this.mWeakReference.get();
                if (context == null) {
                    return false;
                }
                Resources mResources = context.getResources();
                new AlertDialog.Builder(context).setMessage((CharSequence)mResources.getString(R.string.web_leave_app_and_go_other_page, new Object[]{WebViewCompat.getApplicationName(context)})).setTitle((CharSequence)mResources.getString(R.string.web_tips)).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                }).setPositiveButton((CharSequence)mResources.getString(R.string.web_leave), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        DefaultWebViewClient.this.lookup(url);
                    }
                }).create().show();
                return true;
            }
        }
        return false;
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        if (newScale - oldScale > 7.0f) {
            view.setInitialScale((int)(oldScale / newScale * 100.0f));
        }
    }

    public static Builder asBuilder() {
        return new Builder();
    }

    static {
        _SCHEMA_LIST.add("http");
        _SCHEMA_LIST.add("https");
        _SCHEMA_LIST.add("file");
        _SCHEMA_LIST.add("weixin");
        _SCHEMA_LIST.add(INTENT_SCHEME);
        _SCHEMA_LIST.add(ALIPAYS_SCHEME);
        _SCHEMA_LIST.add(SCHEME_SMS);
        _SCHEMA_LIST.add("mailto");
        _SCHEMA_LIST.add("tel");
        _SCHEMA_LIST.add("geo");
    }

    public static class Builder {
        private Activity mActivity;
        private boolean mWebClientHelper;
        private boolean mIsInterceptUnknownScheme;
        private int mLinkPageOpenMode = 1;

        private Builder() {
        }

        public Builder component(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder autoDealLink(boolean auto) {
            this.mWebClientHelper = auto;
            return this;
        }

        public Builder interceptUnknownSchema(boolean interceptUnkownScheme) {
            this.mIsInterceptUnknownScheme = interceptUnkownScheme;
            return this;
        }

        public Builder linkPageOpenMode(int linkPageOpenMode) {
            if (linkPageOpenMode < 0 || linkPageOpenMode > 2) {
                throw new IllegalArgumentException("bad linkPageOpenMode");
            }
            this.mLinkPageOpenMode = linkPageOpenMode;
            return this;
        }

        public DefaultWebViewClient build() {
            return new DefaultWebViewClient(this);
        }
    }
}

