/*
 * Decompiled with CFR 0.152.
 */
package com.takwolf.android.widget;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import java.util.ArrayList;
import java.util.List;

public class WebView
extends android.webkit.WebView {
    private List<OnScrollListener> onScrollListenerList;

    public WebView(@NonNull Context context) {
        super(context);
    }

    public WebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public WebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public WebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.onScrollListenerList != null && this.onScrollListenerList.size() > 0) {
            for (OnScrollListener onScrollListener : this.onScrollListenerList) {
                onScrollListener.onScrollChanged(l, t, oldl, oldt);
            }
        }
    }

    public void addOnScrollListener(OnScrollListener listener) {
        if (this.onScrollListenerList == null) {
            this.onScrollListenerList = new ArrayList<OnScrollListener>();
        }
        this.onScrollListenerList.add(listener);
    }

    public void removeOnScrollListener(OnScrollListener listener) {
        if (this.onScrollListenerList != null) {
            this.onScrollListenerList.remove(listener);
        }
    }

    public void clearOnScrollListeners() {
        if (this.onScrollListenerList != null) {
            this.onScrollListenerList.clear();
        }
    }

    public static interface OnScrollListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }
}

