/*
 * Decompiled with CFR 0.152.
 */
package com.takwolf.android.lock9;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.takwolf.android.lock9.R;
import java.util.ArrayList;
import java.util.List;

public class Lock9View
extends ViewGroup {
    private Paint paint;
    private Bitmap bitmap;
    private Canvas canvas;
    private List<Pair<NodeView, NodeView>> lineList;
    private NodeView currentNode;
    private StringBuilder pwdSb;
    private CallBack callBack;
    private Drawable nodeSrc;
    private Drawable nodeOnSrc;

    public Lock9View(Context context) {
        this(context, null);
    }

    public Lock9View(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Lock9View(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public Lock9View(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.initFromAttributes(attrs, defStyleAttr);
    }

    private void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Lock9View, defStyleAttr, 0);
        this.nodeSrc = a.getDrawable(R.styleable.Lock9View_nodeSrc);
        this.nodeOnSrc = a.getDrawable(R.styleable.Lock9View_nodeOnSrc);
        int lineColor = Color.argb((int)0, (int)0, (int)0, (int)0);
        lineColor = a.getColor(R.styleable.Lock9View_lineColor, lineColor);
        float lineWidth = 20.0f;
        lineWidth = a.getDimension(R.styleable.Lock9View_lineWidth, lineWidth);
        a.recycle();
        this.paint = new Paint(4);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(lineWidth);
        this.paint.setColor(lineColor);
        this.paint.setAntiAlias(true);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.bitmap = Bitmap.createBitmap((int)dm.widthPixels, (int)dm.widthPixels, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas();
        this.canvas.setBitmap(this.bitmap);
        for (int n = 0; n < 9; ++n) {
            NodeView node = new NodeView(this.getContext(), n + 1);
            this.addView(node);
        }
        this.lineList = new ArrayList<Pair<NodeView, NodeView>>();
        this.pwdSb = new StringBuilder();
        this.setWillNotDraw(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, widthMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed) {
            return;
        }
        int width = right - left;
        int nodeWidth = width / 3;
        int nodePadding = nodeWidth / 6;
        for (int n = 0; n < 9; ++n) {
            NodeView node = (NodeView)this.getChildAt(n);
            int row = n / 3;
            int col = n % 3;
            int l = col * nodeWidth + nodePadding;
            int t = row * nodeWidth + nodePadding;
            int r = col * nodeWidth + nodeWidth - nodePadding;
            int b = row * nodeWidth + nodeWidth - nodePadding;
            node.layout(l, t, r, b);
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: 
            case 2: {
                NodeView nodeAt = this.getNodeAt(event.getX(), event.getY());
                if (nodeAt == null && this.currentNode == null) {
                    return true;
                }
                this.clearScreenAndDrawList();
                if (this.currentNode == null) {
                    this.currentNode = nodeAt;
                    this.currentNode.setHighLighted(true);
                    this.pwdSb.append(this.currentNode.getNum());
                } else if (nodeAt == null || nodeAt.isHighLighted()) {
                    this.canvas.drawLine((float)this.currentNode.getCenterX(), (float)this.currentNode.getCenterY(), event.getX(), event.getY(), this.paint);
                } else {
                    this.canvas.drawLine((float)this.currentNode.getCenterX(), (float)this.currentNode.getCenterY(), (float)nodeAt.getCenterX(), (float)nodeAt.getCenterY(), this.paint);
                    nodeAt.setHighLighted(true);
                    Pair pair = new Pair((Object)this.currentNode, (Object)nodeAt);
                    this.lineList.add((Pair<NodeView, NodeView>)pair);
                    this.currentNode = nodeAt;
                    this.pwdSb.append(this.currentNode.getNum());
                }
                this.invalidate();
                return true;
            }
            case 1: {
                if (this.pwdSb.length() <= 0) {
                    return super.onTouchEvent(event);
                }
                if (this.callBack != null) {
                    this.callBack.onFinish(this.pwdSb.toString());
                    this.pwdSb.setLength(0);
                }
                this.currentNode = null;
                this.lineList.clear();
                this.clearScreenAndDrawList();
                for (int n = 0; n < this.getChildCount(); ++n) {
                    NodeView node = (NodeView)this.getChildAt(n);
                    node.setHighLighted(false);
                }
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void clearScreenAndDrawList() {
        this.canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (Pair<NodeView, NodeView> pair : this.lineList) {
            this.canvas.drawLine((float)((NodeView)((Object)pair.first)).getCenterX(), (float)((NodeView)((Object)pair.first)).getCenterY(), (float)((NodeView)((Object)pair.second)).getCenterX(), (float)((NodeView)((Object)pair.second)).getCenterY(), this.paint);
        }
    }

    private NodeView getNodeAt(float x, float y) {
        for (int n = 0; n < this.getChildCount(); ++n) {
            NodeView node = (NodeView)this.getChildAt(n);
            if (!(x >= (float)node.getLeft() && x < (float)node.getRight() && y >= (float)node.getTop() && y < (float)node.getBottom())) continue;
            return node;
        }
        return null;
    }

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    public static interface CallBack {
        public void onFinish(String var1);
    }

    public class NodeView
    extends View {
        private int num;
        private boolean highLighted;

        private NodeView(Context context) {
            super(context);
        }

        public NodeView(Context context, int num) {
            this(context);
            this.num = num;
            this.highLighted = false;
            if (this$0.nodeSrc == null) {
                this.setBackgroundResource(0);
            } else {
                this.setBackgroundDrawable(this$0.nodeSrc);
            }
        }

        public boolean isHighLighted() {
            return this.highLighted;
        }

        public void setHighLighted(boolean highLighted) {
            this.highLighted = highLighted;
            if (highLighted) {
                if (Lock9View.this.nodeOnSrc == null) {
                    this.setBackgroundResource(0);
                } else {
                    this.setBackgroundDrawable(Lock9View.this.nodeOnSrc);
                }
            } else if (Lock9View.this.nodeSrc == null) {
                this.setBackgroundResource(0);
            } else {
                this.setBackgroundDrawable(Lock9View.this.nodeSrc);
            }
        }

        public int getCenterX() {
            return (this.getLeft() + this.getRight()) / 2;
        }

        public int getCenterY() {
            return (this.getTop() + this.getBottom()) / 2;
        }

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }
    }
}

